//
//  PdAudioSimpleViewController.m
//  PdAudioSimple
//
//  Created by Markus Konrad on 07.03.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "PdAudioSimpleViewController.h"

@implementation PdAudioSimpleViewController

#pragma mark UIViewController messages

- (void)viewDidLoad {
    [super viewDidLoad];
    // initialize Pure Data stuff
    pdAudio = [[PdAudio alloc] initWithSampleRate:44100.0
                                andTicksPerBuffer:64
                         andNumberOfInputChannels:2
                        andNumberOfOutputChannels:2];
    
    // This class conforms to PdReceiverDelegate, because it is the delegate for PdBase
    // Set the delegate so this object can receive messages from PureData
    [PdBase setDelegate:self];
    
    // open patch located in app bundle
    [PdBase openPatch:[[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:@"audio_out.pd"]];
    
    // start pd
    [PdBase computeAudio:YES];
    [pdAudio play];
}

- (void)dealloc {
    [pdAudio release];
    
    [super dealloc];
}

# pragma mark actions

- (IBAction)masterVolSliderChanged:(id)sender {
    UISlider *slider = (UISlider *)sender;
    
    // Send new volume value to LibPd
    [PdBase sendFloat:slider.value toReceiver:@"master_vol"];
}

#pragma mark PdReceiverDelegate messages

- (void)receivePrint:(NSString *)message {
    // Receive messages from LibPd
    NSLog(@"Print from Pd: %@", message);
}

@end
