//
//  AudioController.h
//  iPhoneAudio
//
//  Created by Markus Konrad on 11.11.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

// Test frequency
static const float kBaseFreq = 440.0f;
// Native iphone sample rate of 44.1kHz, same as a CD.
static const Float64 kSampleRate = 44100.0;
// This is crucial. The smaller the buffer, the smaller the latency but the higher CPU usage. This is only the REQUESTED buffer size. CoreAudio sets it to whatever is possible. See log output for the real buffer size (block size)
static const Float32 kBufferSize = 4.0f * 1024;

// default audio session category for low latency
static const UInt32 kAudioCategory = kAudioSessionCategory_PlayAndRecord;

// specify number of channels for in- and output
static const UInt32 kNumInputChannels = 0;
static const UInt32 kNumOuputChannels = 2;

@interface AudioController : NSObject {
	@public AudioUnit audioUnit;    // CoreAudio AudioUnit
    
    @public float sinPhase;	// Sine Wave Phase marker
    @public float sinFreq;  // Sine Wave Frequency
    
    @public float masterVolume; // Master volume
}

/*!
 @property masterVolume
 @abstract Sets the master volume
 */
@property float masterVolume;

/*!
 @method play
 @abstract Starts the Audio Session
 */
- (void)play;

/*!
 @method pause
 @abstract Pauses the Audio Session
 */
- (void)pause;

@end
