//
//  PdAudioBendingViewController.m
//  PdAudioBending
//
//  Created by Markus Konrad on 08.03.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "PdAudioBendingViewController.h"

@implementation PdAudioBendingViewController

#pragma mark UIViewController messages

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    
    // init variables
    audioOn = NO;
    notePlaying = NO;
    
    // initialize Pure Data stuff
    pdAudio = [[PdAudio alloc] initWithSampleRate:44100.0
                                andTicksPerBuffer:64
                         andNumberOfInputChannels:2
                        andNumberOfOutputChannels:2];
    
    // This class conforms to PdReceiverDelegate, because it is the delegate for PdBase
    // Set the delegate so this object can receive messages from PureData
    [PdBase setDelegate:self];
    
    // open patch located in app bundle
    [PdBase openPatch:[[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:@"audio_out.pd"]];
    
    // init PdBase
    [PdBase computeAudio:NO];
    
    // register accelerometer
    [[UIAccelerometer sharedAccelerometer] setDelegate:self];
}


- (void)dealloc {
    [pdAudio release];
    [super dealloc];
}

# pragma mark actions

- (IBAction)masterVolSliderChanged:(id)sender {
    UISlider *slider = (UISlider *)sender;
    
    // Send new volume value to LibPd
    [PdBase sendFloat:slider.value toReceiver:@"master_vol"];
}

- (IBAction)toggleAudio:(id)sender {
    UIButton *btn = (UIButton *)sender;
    
    audioOn = !audioOn;
    
    [PdBase computeAudio:audioOn];
    
    if (audioOn) {
        [pdAudio play];
        [btn setTitle:@"Audio on" forState:UIControlStateNormal];
    }
    else {
        [pdAudio pause];
        [btn setTitle:@"Audio off" forState:UIControlStateNormal];
    }
}

- (IBAction)playNote:(id)sender {
    notePlaying = YES;
    NSArray *noteData = [NSArray arrayWithObjects:[NSNumber numberWithFloat:64.0f],
                         [NSNumber numberWithFloat:90.0f], nil];
    [PdBase sendMessage:@"note"
          withArguments:noteData
             toReceiver:@"note_in"];
}

- (IBAction)stopNote:(id)sender {
    NSArray *noteData = [NSArray arrayWithObjects:[NSNumber numberWithInt:0],
                         [NSNumber numberWithInt:0], nil];
    [PdBase sendMessage:@"note"
          withArguments:noteData
             toReceiver:@"note_in"];
    notePlaying = NO;
}

#pragma mark UIAccelerometerDelegate messages

- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration {
	static float prevX=0, prevY=0;
	
    static const float kFilterFactor = 0.1f;
	
	float accelX = (float) acceleration.x * kFilterFactor + (1- kFilterFactor)*prevX;
	float accelY = (float) acceleration.y * kFilterFactor + (1- kFilterFactor)*prevY;
	
	prevX = accelX;
	prevY = accelY;
    
    if (notePlaying) {
        [PdBase sendMessage:@"bend"
              withArguments:[NSArray arrayWithObject:[NSNumber numberWithFloat:accelY]]
                 toReceiver:@"note_in"];
    }
    
    [PdBase sendFloat:accelX
           toReceiver:@"stereo_bend"];
}

#pragma mark PdReceiverDelegate messages

- (void)receivePrint:(NSString *)message {
    // Receive messages from LibPd
    NSLog(@"Print from Pd: %@", message);
}

@end
