//
//  AudioController.h
//  iPhoneAudio
//
//  Created by Markus Konrad on 11.11.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

#import <QuartzCore/CABase.h>

@interface AudioController : NSObject {    
@public
    // CoreAudio AudioUnit
    AudioUnit audioUnit;
    
    float *sinTable;    // precalculated Sine Wave table (see kSineWaveTableRes)

    float *sinPhases;   // Sine Wave Phase
    float *sinPhaseIncrements;  // Sine Wave Phase Increments

    float ampModPhase;  // Amplitude modulation phase
    float ampModFreq;   // Amplitude modulation frequency
    float volumeLeft;   // Volume on the left channel
    float volumeRight;  // Volume on the right channel
    float masterVolume; // Master volume
    float volEnvelopeAmp;   // Volume envelope amplitude
    
    // all in seconds with millisecond-precision:
    double noteOnTs;    // Note on timestamp
    double noteOffTs;   // Note off timestamp
    double rampUp;      // Ramp up ("fade in") value
    double rampDown;    // Ramp down ("fade out") value
}

@property float ampModFreq;
@property float volumeLeft;
@property float volumeRight;
@property float masterVolume;

// Start the Audio Session
- (void)play;

// Pause the Audio Session
- (void)pause;

// Play a note with a specified frequency
- (void)noteOn:(float)freq;

// Stop playing the note
- (void)noteOff;

@end
