//
//  iPhoneAudioViewController.m
//  iPhoneAudio
//
//  Created by Markus Konrad on 11.11.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "iPhoneAudioViewController.h"

@implementation iPhoneAudioViewController


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    
    // init audio backend
    audioController = [[AudioController alloc] init];
    
    // register accelerometer
    [[UIAccelerometer sharedAccelerometer] setDelegate:self];
}

- (void)dealloc {
    [audioController pause];
    [audioController release];
    [super dealloc];
}

# pragma mark actions

- (IBAction)masterVolSliderChanged:(id)sender {
    UISlider *slider = (UISlider *)sender;
    
    [audioController setMasterVolume:slider.value];
}

- (IBAction)toggleAudio:(id)sender {
    UIButton *btn = (UIButton *)sender;
    
    audioOn = !audioOn;
    
    if (audioOn) {
        [audioController play];
        [btn setTitle:@"Audio on" forState:UIControlStateNormal];
    }
    else {
        [audioController pause];
        [btn setTitle:@"Audio off" forState:UIControlStateNormal];
    }
}

- (IBAction)playNote:(id)sender {
    [audioController noteOn:440.0f];
    NSLog(@"Note on!");
}

- (IBAction)stopNote:(id)sender {
    [audioController noteOff]; 
    NSLog(@"Note off!");
}

#pragma mark UIAccelerometerDelegate messages

- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration {
	static float prevX=0, prevY=0;
	
    static const float kFilterFactor = 0.1f;
	
	float accelX = (float) acceleration.x * kFilterFactor + (1- kFilterFactor)*prevX;
	float accelY = (float) acceleration.y * kFilterFactor + (1- kFilterFactor)*prevY;
	
	prevX = accelX;
	prevY = accelY;

    // Y-Axis rotation modifies amplitude modulation frequency:
    [audioController setAmpModFreq:(accelY + 1.0f) * (accelY + 1.0f) * 100.0f];    
    
    // X-Axis rotation modifies stereo
    [audioController setVolumeLeft:(1.0f - accelX) / 2.0f];
    [audioController setVolumeRight:(1.0f + accelX) / 2.0f];
}


@end
