//
//  AudioController.h
//  iPhoneAudio
//
//  Created by Markus Konrad on 11.11.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

#import <QuartzCore/CABase.h>

// Test frequency
static const float kBaseFreq = 440.0f;
// Native iphone sample rate of 44.1kHz, same as a CD.
static const Float64 kSampleRate = 44100.0;
// This is crucial. The smaller the buffer, the smaller the latency but the higher CPU usage. This is only the REQUESTED buffer size. CoreAudio sets it to whatever is possible. See log output for the real buffer size (block size)
static const Float32 kBufferSize = 4.0f * 1024;

// default audio session category for low latency
static const UInt32 kAudioCategory = kAudioSessionCategory_PlayAndRecord;

// specify number of channels for in- and output
static const UInt32 kNumInputChannels = 0;
static const UInt32 kNumOuputChannels = 2;

@interface AudioController : NSObject {    
@public
    // CoreAudio AudioUnit
    AudioUnit audioUnit;

    float sinPhase; // Sine Wave Phase
    float sinFreq;  // Sine Wave Frequency

    float ampModPhase;  // Amplitude modulation phase
    float ampModFreq;   // Amplitude modulation frequency
    float volumeLeft;   // Volume on the left channel
    float volumeRight;  // Volume on the right channel
    float masterVolume; // Master volume
    float volEnvelopeAmp;   // Volume envelope amplitude
    
    // all in seconds with millisecond-precision:
    double noteOnTs;    // Note on timestamp
    double noteOffTs;   // Note off timestamp
    double rampUp;      // Ramp up ("fade in") value
    double rampDown;    // Ramp down ("fade out") value
}

@property float ampModFreq;
@property float volumeLeft;
@property float volumeRight;
@property float masterVolume;

// Start the Audio Session
- (void)play;

// Pause the Audio Session
- (void)pause;

// Play a note with a specified frequency
- (void)noteOn:(float)freq;

// Stop playing the note
- (void)noteOff;

@end
