//
//  MIDINote.h
//  AudioSeq
//
//  Created by Markus Konrad on 14.12.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MIDINote : NSObject {
    float pitch;
    float velocity;
	float duration;
}

@property float pitch;      // MIDI-pitch 0...127
@property float velocity;   // MIDI-velocity 0...127
@property float duration;   // beats until note-off

// creates autoreleased MIDINote
+ (MIDINote *)midiNoteWithPitch:(float)pPitch andVelocity:(float)pVelo andDuration:(float)pDur;

// for non-autoreleased MIDINote
- (id)initWithPitch:(float)pPitch andVelocity:(float)pVelo andDuration:(float)pDur;

@end
