//
//  MIDINote.m
//  AudioSeq
//
//  Created by Markus Konrad on 14.12.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "MIDINote.h"


@implementation MIDINote

@synthesize pitch, velocity, duration;


+ (MIDINote *)midiNoteWithPitch:(float)pPitch andVelocity:(float)pVelo andDuration:(float)pDur {
    return [[[MIDINote alloc] initWithPitch:pPitch andVelocity:pVelo andDuration:pDur] autorelease];
}

- (id)initWithPitch:(float)pPitch andVelocity:(float)pVelo andDuration:(float)pDur {
    if ((self = [super init])) {
        pitch = pPitch;
        velocity = pVelo;
        duration = pDur;
    }
    
    return self;
}

#pragma mark parent messages

- (NSString *)description {
    return [NSString stringWithFormat:@"MIDINote: -pitch: %f -velocity: %f -duration: %f", pitch, velocity, duration];
}

@end
