//
//  PdSoundEngineViewController.h
//  PdSoundEngine
//
//  Created by Markus Konrad on 13.01.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "SeqView.h"
#import "SoundEngine.h"

@class SeqView;

@interface PdSoundEngineViewController : UIViewController {
    SoundEngine *soundEngine;
    
    NSMutableArray *seqViews; //NSMutableArray of SeqView objects
    int curSeqView; //index of current SeqView in seqViews
    
    UIButton *onOffButton;
    UIButton *nextSeqView;
    UIButton *prevSeqView;
    UISlider *masterVolSlider;
    UISlider *speedSlider;
}

@property (nonatomic, readonly) SoundEngine *soundEngine;
@property (nonatomic, readonly) UIButton *nextSeqView;
@property (nonatomic, readonly) UIButton *prevSeqView;

-(void)onOffButtonAction:(id)sender;
-(void)changeSeqViewAction:(id)sender;
-(void)masterVolChangedAction:(id)sender;
-(void)speedChangedAction:(id)sender;

-(void)_addSeqView;

@end

