//
//  PdSoundEngineViewController.m
//  PdSoundEngine
//
//  Created by Markus Konrad on 13.01.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "PdSoundEngineViewController.h"

@implementation PdSoundEngineViewController

@synthesize soundEngine;
@synthesize prevSeqView;
@synthesize nextSeqView;

/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/



// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    
    // get the sound engine up and running!
    soundEngine = [[SoundEngine alloc] init];
    
    // set attributes of this view
    self.view.backgroundColor = [UIColor blackColor];
    
    // embed SeqView
    seqViews = [[NSMutableArray alloc] initWithCapacity:5];
    [self _addSeqView];
    //[self _addSeqView];
    //[self _addSeqView];
    
    curSeqView = 0;
    [[seqViews objectAtIndex:curSeqView] setHidden:NO];
    
    // create SeqView change buttons
    prevSeqView = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    prevSeqView.frame = CGRectMake(80, 20, 40, 40);
    [prevSeqView setTitle:@"<" forState:UIControlStateNormal];
    [prevSeqView addTarget:self action:@selector(changeSeqViewAction:) forControlEvents:UIControlEventTouchUpInside];
    [prevSeqView setHidden:YES];
    [self.view addSubview:prevSeqView];
    
    nextSeqView = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    nextSeqView.frame = CGRectMake(140, 20, 40, 40);
    [nextSeqView setTitle:@">" forState:UIControlStateNormal];
    [nextSeqView addTarget:self action:@selector(changeSeqViewAction:) forControlEvents:UIControlEventTouchUpInside];
    [prevSeqView setHidden:YES];
    [self.view addSubview:nextSeqView];
    
    // create on / off button
    onOffButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    onOffButton.frame = CGRectMake(20, 20, 40, 40);
    [onOffButton setTitle:@"Off" forState:UIControlStateNormal];
    [onOffButton addTarget:self action:@selector(onOffButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:onOffButton];
    
    // create master volume slider
    masterVolSlider = [[UISlider alloc] initWithFrame:CGRectMake(200, 20, 200, 40)];
    masterVolSlider.minimumValue = 0.0f;
    masterVolSlider.maximumValue = 1.0f;
    masterVolSlider.value = 0.5f;
    [masterVolSlider addTarget:self action:@selector(masterVolChangedAction:) forControlEvents:UIControlEventValueChanged];
    [self.view addSubview:masterVolSlider];
    
    // create speed slider
    speedSlider = [[UISlider alloc] initWithFrame:CGRectMake(440, 20, 200, 40)];
    speedSlider.minimumValue = 30.0f;
    speedSlider.maximumValue = 180.0f;
    speedSlider.value = 60.0f;
    [speedSlider addTarget:self action:@selector(speedChangedAction:) forControlEvents:UIControlEventValueChanged];
    [self.view addSubview:speedSlider];
}

- (void)onOffButtonAction:(id)sender {
    if (onOffButton.titleLabel.text == @"Off") {
        [soundEngine start];
        [onOffButton setTitle:@"On" forState:UIControlStateNormal];
    } else {
        [soundEngine stop];
        [onOffButton setTitle:@"Off" forState:UIControlStateNormal];
    }

}

-(void) changeSeqViewAction:(id)sender {
    UIButton *btn = (UIButton *)sender;
    int changeIndex = 0;
    UIViewAnimationOptions transitionType = UIViewAnimationOptionTransitionNone;
    if (btn.titleLabel.text == @">") {
        if (curSeqView >= ([seqViews count] - 1)) {
            [self _addSeqView];
        }
        
        changeIndex = 1;
        transitionType = UIViewAnimationOptionTransitionFlipFromRight;
        
        [prevSeqView setHidden:NO];
    } else if (btn.titleLabel.text == @"<" && curSeqView > 0) {
        changeIndex = -1;
        transitionType = UIViewAnimationOptionTransitionFlipFromLeft;
        
        if (curSeqView+changeIndex == 0) {
            [prevSeqView setHidden:YES];
        }
    } else {
        return;
    }

    [UIView transitionWithView:self.view
                      duration:0.5
                       options:transitionType
                    animations:^{
                        [((SeqView *)[seqViews objectAtIndex:curSeqView]) setHidden:YES];
                        [((SeqView *)[seqViews objectAtIndex:(curSeqView+changeIndex)]) setHidden:NO];
                    }
                    completion:^(BOOL finished){
                        // what to do on completion?
                    }];
    
    curSeqView+=changeIndex;
}

-(void)masterVolChangedAction:(id)sender {
    [soundEngine setMasterVol:masterVolSlider.value];
}

-(void)speedChangedAction:(id)sender {
    [soundEngine.sequencer setSpeed:speedSlider.value];
}

- (void) _addSeqView {
    @synchronized (self) {
        CGRect seqViewRect = CGRectMake(20, 100, 960, 640);
        SeqView *seqView = [[SeqView alloc] initWithFrame:seqViewRect andParentViewController:self];
        [seqView setHidden: YES];
        [seqViews addObject:seqView];
        
        [[self view] addSubview:seqView];
    }
}


// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationLandscapeLeft) ||
           (interfaceOrientation == UIInterfaceOrientationLandscapeRight);
}

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [soundEngine release];
    [seqViews release];
    [masterVolSlider release];
    [speedSlider release];
    
    [super dealloc];
}

@end
