//
//  SeqView.h
//  PdAudio
//
//  Created by Markus Konrad on 19.12.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PdSoundEngineViewController.h"
#import "SoundEngine.h"
#import "Sequencer.h"
#import "MIDINote.h"
#import "PdBase.h"

#define NUM_INSTRUMENTS 2

#define INITIAL_SEQUENCER_BARS 16
#define MAX_SEQUENCER_BARS 21
#define INITIAL_SEQUENCER_TRACKS 14

#define SEQ_VIEW_ROW_BORDER_LEFT 10
#define SEQ_VIEW_ROW_BORDER_RIGHT 10
#define SEQ_VIEW_BUTTON_W 35
#define SEQ_VIEW_BUTTON_H 35
#define SEQ_VIEW_BUTTON_BORDER 5

@class PdSoundEngineViewController;

@interface SeqView : UIView<SequencerViewDelegate> {
    PdSoundEngineViewController *parentViewController;
    
    SoundEngine *soundEngine;
    int trackId;
    bool firstNoteSet;
    float trackNoteDur;
    
    NSMutableDictionary *noteIds;   // NSNumber -> NSNumber: maps button-tags to note-ids
    
    NSMutableArray *buttons;                //NSMutableArray of NSMutableArray with SeqButtons for step sequencer
//    NSMutableArray *ctrlBtnsAddButton;      //NSMutableArray with UIButtons for adding button to a row. Index is equal to row-number of self.buttons
//    NSMutableArray *ctrlBtnsRemoveButton;   //NSMutableArray with UIButtons for removing button from a row. Index is equal to row-number of self.buttons
    UIButton *addColumnButton;
    UIButton *removeColumnButton;
    UIButton *changeInstrButton;
    UISlider *trackVolSlider;
    UISlider *trackNoteDurSlider;
}

@property (readonly) NSMutableArray *buttons;

- (id)initWithFrame:(CGRect)frame andParentViewController:(PdSoundEngineViewController *)parent;

- (void)addButtonRow;
- (void)addButtonToRow:(int)rowNum;
- (void)addButtonColumn;
- (void)removeButtonColumn;

- (void)toggleCell:(id)sender;
- (void)addButtonColumnAction:(id)sender;
- (void)removeButtonColumnAction:(id)sender;
- (void)changeInstrAction:(id)sender;
- (void)trackVolChangedAction:(id)sender;
- (void)trackNoteDurChangedAction:(id)sender;

- (void)_createInitialButtons;
- (void)_moveElement:(UIView *)view byX:(int)x andY:(int)y;
- (void)_setButtonTags;
- (UIButton *)_buttonForNoteId:(int)noteId atBar:(int)bar;

@end
