//
//  Sequencer.h
//  AudioSeq
//
//  Created by Markus Konrad on 14.12.10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MIDINote.h"

@class Sequencer;

@protocol SequencerMIDIDelegate

-(void)playsNote:(MIDINote *)note withInstrument:(int)instrNum atVolume:(float)vol;
-(void)stopsNote:(MIDINote *)note ofInstrument:(int)instrNum;

@end

@protocol SequencerViewDelegate

-(void)playsNote:(int)noteId atBar:(int)bar;
-(void)stopsNote:(int)noteId atBar:(int)bar;

@optional
-(void)playsBar:(int)bar;

@end


/*!
 *  Defines Track Attribute Types, that are stored for each track in the
 *  trackAttrib-Array
 */
enum {
    kTrackAttribInstrument = 0,
    kTrackAttribVolume = 1,
    kTrackAttribLength = 2
};


@interface Sequencer : NSObject {
    NSMutableArray *tracks;         // NSMutableArray with tracks. Each track consists of <length> bars, where each bar holds an NSMutableDictionary of noteId -> MIDINote pairs
    NSMutableArray *trackAttrib;	// Array das die eigenschaften der bestimmten Tracks speichter
									// trackAttrib[n][0] = String über das Instrumet
									// trackAttrib[n][1] = ...
									// trackAttrib[n][2] = ...
    NSMutableArray *trackBarCounters;   // NSMutableArray of NSNumbers with currently playing bar for each track
    float speed;    //BPM
    id midiDelegate;    // delegate that implements SequencerMIDIDelegate and gets notified with a MIDINote
    NSMutableArray *viewDelegates;    // array of delegates that implement SequencerViewDelegate and get notified with noteId and currently playing bar. Each track has one viewDelegate
	bool playing;
}

@property float speed;

- (id)initWithMidiDelegate:(id)pMidiDelegate;
- (int)addTrackWithView:(id)viewDelegate andInstrument:(int)instrument andVolume:(float)volume andLength:(int)length;
- (int)insertNote:(MIDINote *)note toTrack:(int)track atBar:(int)bar;

- (void)setAttrib:(int)attrIndex value:(float)v forTrack:(int)track;
- (float)getAttrib:(int)attrIndex forTrack:(int)track;

- (void)playTrack:(int)track;
- (void)pauseTrack:(int)track;
- (void)deleteTrack:(int)track;
- (void)deleteNote:(int)noteId fromBar:(int)bar ofTrack:(int)track;
- (void)addBarToTrack:(int)track;
- (void)deleteBarFromTrack:(int)track;


- (void)_playNotesOfTrack:(NSNumber *)track;
- (void)_stopNote:(NSArray *)paramArray;

@end
