//
//  SoundEngine.h
//  PdSoundEngine
//
//  Created by Markus Konrad on 13.01.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "PdAudioExtended.h"
#import "PdBase.h"
#import "Sequencer.h"

@interface SoundEngine : NSObject<PdReceiverDelegate, SequencerMIDIDelegate> {
   	PdAudioExtended *pdAudio;
    Sequencer *sequencer;
    
    NSArray *instrumentTable;
    
    float masterVol;
    bool isStarted;
}

@property (nonatomic, readonly) bool isStarted;
@property (nonatomic, readonly) Sequencer *sequencer;

- (void)start;
- (void)stop;

- (void)setMasterVol:(float)vol;

- (void)_copyDemoPatchesToUserDomain;
- (void)_openPatch:(NSString *)patch;
- (void)_sendNotePitch:(float)pitch andVelocity:(float)velocity toInstrument:(int)instrNum;

@end
