//
//  SoundEngine.m
//  PdSoundEngine
//
//  Created by Markus Konrad on 13.01.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "SoundEngine.h"


@implementation SoundEngine

@synthesize isStarted;
@synthesize sequencer;

NSString *patchFileTypeExtension = @"pd";  

#pragma mark public messages

- (void)start {
    [PdBase computeAudio:YES];  //todo: fade-in to prevent clicks
    [PdBase sendFloat:masterVol toReceiver:@"master_vol"];
    [pdAudio play];
    
    isStarted = YES;
}

- (void)stop {
    [pdAudio pause];
    [PdBase computeAudio:NO];   //todo: fade-out to prevent clicks   
    
    isStarted = NO;
}

- (void)setMasterVol:(float)vol {
    [PdBase sendFloat:vol toReceiver:@"master_vol"];
    masterVol = vol;
}

#pragma mark NSObject messages

-(id)init {
    if ((self = [super init])) {
        // set defaults
        masterVol = 0.5f;
        isStarted = NO;
        
        instrumentTable = [[NSArray alloc] initWithObjects: @"classicsub_instr", @"saw_instr", nil];
        
        // initialize Pure Data stuff
        pdAudio = [[PdAudio alloc] initWithSampleRate:44100.0 andTicksPerBuffer:64 andNumberOfInputChannels:2 andNumberOfOutputChannels:2];
        
        [PdBase setDelegate:self];
        
        // open patch located in app bundle
        //[self _copyDemoPatchesToUserDomain];
        [self _openPatch:@"poly_seq.pd"];
        
        [PdBase computeAudio:NO];
        
        // initialize sequencer
        sequencer = [[Sequencer alloc] initWithMidiDelegate:self]; // the sound engine sends the MIDI notes, therefore register as midiDelegate
    }
    
    return self;
}

-(void)dealloc {
    [instrumentTable release];
    [pdAudio release];
    
    [super dealloc];
}

#pragma mark private messages

- (void)_openPatch:(NSString *)patch {
	//NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	//NSString *documentsDirectory = [paths objectAtIndex:0];
	
	//[PdBase openPatch: [documentsDirectory stringByAppendingPathComponent:patch]];
    [PdBase openPatch: [[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:patch]];
}

- (void)_copyDemoPatchesToUserDomain {
	NSFileManager *fm = [NSFileManager defaultManager];
	NSError *fileError;
	
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *bundlePath = [mainBundle bundlePath];
	
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsDirectory = [paths objectAtIndex:0];
	
	NSArray *bundleFiles = [fm contentsOfDirectoryAtPath:bundlePath error:&fileError];
	
	for( NSString *patchFile in bundleFiles )
	{
		if ([[patchFile pathExtension] isEqualToString:patchFileTypeExtension ])
		{
			NSString *bundlePatchFilePath = [bundlePath stringByAppendingPathComponent:patchFile]; 
			NSString *documentsPatchFilePath = [documentsDirectory stringByAppendingPathComponent:patchFile];
			
			if ([fm fileExistsAtPath:bundlePatchFilePath]) 
			{
				if( ![fm fileExistsAtPath:documentsPatchFilePath] )
					if( ![fm copyItemAtPath:bundlePatchFilePath toPath: documentsPatchFilePath error:&fileError] )
						NSLog(@"Error copying demo patch:%@", [fileError localizedDescription]);
			} 
		}
	}
}


- (void)_sendNotePitch:(float)pitch andVelocity:(float)velocity toInstrument:(int)instrNum {
    NSArray *msgArray = [NSArray arrayWithObjects:
                         [NSNumber numberWithInt:pitch],
                         [NSNumber numberWithInt:velocity],
                         nil];
    if (isStarted) {
        [PdBase sendMessage:[instrumentTable objectAtIndex:(instrNum-1)]
              withArguments:msgArray
                 toReceiver:@"note"];       
    }
}

#pragma mark SequencerDelegate messages

-(void)playsNote:(MIDINote *)note withInstrument:(int)instrNum atVolume:(float)vol {
    NSLog(@"Note played: %f %f", note.pitch, (note.velocity * vol));
    
    [self _sendNotePitch:note.pitch andVelocity:(note.velocity * vol) toInstrument:instrNum];
}

-(void)stopsNote:(MIDINote *) note ofInstrument:(int)instrNum {
	NSLog(@"Note stopped: %f %f", note.pitch, note.velocity);
	
    [self _sendNotePitch:note.pitch andVelocity:0 toInstrument:instrNum];
}

#pragma mark PdReceiverDelegate messages

- (void)receivePrint:(NSString *)message {
    NSLog(@"Print from Pd: %@", message);
}

@end
