/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;

public class ImageButtonOverlay
extends OverlayBase {
    public static final int INACTIVE_IMAGE = 0;
    public static final int ACTIVE_IMAGE = 1;
    public static final int CLICKED_IMAGE = 2;
    public static final int MOUSEOVER_IMAGE = 3;
    static final int numBuffers = 4;
    boolean[] hasImage = new boolean[4];
    boolean mouseOver = false;
    boolean stuck = false;
    boolean clicked = false;

    public ImageButtonOverlay(Canvas3D canvas, Rectangle imageSpace, BufferedImage[] image) {
        this(canvas, imageSpace, true, false, image);
    }

    public ImageButtonOverlay(Canvas3D canvas, Rectangle imageSpace, boolean clipAlpha, boolean blendAlpha, BufferedImage[] image) {
        super(canvas, imageSpace, clipAlpha, blendAlpha, null, 4);
        int i = image.length - 1;
        while (i >= 0) {
            boolean bl = this.hasImage[i] = image[i] != null;
            if (this.hasImage[i]) {
                this.updateBuffer(image[i], i);
            }
            --i;
        }
        this.setActiveBuffer(0);
    }

    protected synchronized void switchButtons() {
        if (this.mouseOver && this.clicked && this.hasImage[2]) {
            this.setActiveBuffer(2);
        } else if (this.mouseOver && this.hasImage[3]) {
            this.setActiveBuffer(3);
        } else if (this.stuck && this.hasImage[1]) {
            this.setActiveBuffer(1);
        } else if (this.hasImage[0]) {
            this.setActiveBuffer(0);
        } else {
            System.err.println("No images to choose from in ImageButtonOverlay");
        }
    }

    @Override
    public void repaint() {
    }
}

