/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import com.xith.java3d.overlay.UpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnActivation;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;

public class LabelOverlay
extends OverlayBase {
    protected AttributedString text;
    protected int visibleLength = 0;
    protected int textLength = 0;
    protected int typingDelta = 0;
    protected Font font;
    protected Color color;
    TypingBehavior typer;
    boolean typing = false;
    Object typingBlock = new Object();

    public LabelOverlay(Canvas3D canvas, Rectangle space) {
        this(canvas, space, "");
    }

    public LabelOverlay(Canvas3D canvas, Rectangle space, String text) {
        this(canvas, space, text, new Font("Helvetica", 1, 14), Color.red, null);
    }

    public LabelOverlay(Canvas3D canvas, Rectangle space, String text, Font font, Color color) {
        this(canvas, space, text, font, color, null);
    }

    public LabelOverlay(Canvas3D canvas, Rectangle space, String text, Font font, Color color, UpdateManager manager) {
        super(canvas, space, manager);
        this.font = font;
        this.color = color;
        this.setText(text);
    }

    public LabelOverlay(Canvas3D canvas, Rectangle space, AttributedString text) {
        this(canvas, space, text, null);
    }

    public LabelOverlay(Canvas3D canvas, Rectangle space, AttributedString text, UpdateManager manager) {
        super(canvas, space, manager);
        this.setText(text);
    }

    @Override
    protected void initialize() {
        this.typer = new TypingBehavior();
        this.typer.setSchedulingBounds((Bounds)new BoundingSphere());
        this.getRoot().addChild((Node)this.typer);
        this.setBackgroundColor(new Color(0, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g) {
        if (this.text != null) {
            AttributedString attributedString = this.text;
            synchronized (attributedString) {
                AttributedCharacterIterator characterIterator = this.text.getIterator(null, 0, this.visibleLength);
                if (characterIterator.getEndIndex() > 0) {
                    TextLayout textLayout = new TextLayout(characterIterator, g.getFontRenderContext());
                    textLayout.draw(g, 0.0f, 3 * this.getBounds().height / 4);
                }
            }
        }
    }

    public void setColor(Color color) {
        if (!this.color.equals(color)) {
            this.color = color;
            this.repaint();
        }
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.repaint();
        }
    }

    public void setText(String text) {
        this.setText(text, text.length());
    }

    public void setText(String text, int typingDelta) {
        this.setText(LabelOverlay.createAttributedString(text, this.font, this.color), typingDelta);
    }

    public void setText(AttributedString text) {
        if (text != null) {
            this.setText(text, text.getIterator().getEndIndex() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(AttributedString text, int typingDelta) {
        if (this.text != text) {
            AttributedString attributedString = text;
            synchronized (attributedString) {
                this.text = text;
                this.textLength = text.getIterator().getEndIndex();
                this.visibleLength = 0;
                this.typingDelta = typingDelta;
            }
            this.typer.type();
        }
    }

    public void backspace(int numCharacters) {
        this.visibleLength = Math.max(0, this.visibleLength - numCharacters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTyping() {
        this.visibleLength = Math.min(this.textLength, this.visibleLength + this.typingDelta);
        this.repaint();
        boolean bl = this.typing = this.visibleLength < this.textLength;
        if (!this.typing) {
            Object object = this.typingBlock;
            synchronized (object) {
                this.typingBlock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTyping() {
        while (this.typing) {
            Object object = this.typingBlock;
            synchronized (object) {
                try {
                    this.typingBlock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setTypingSpeed(long delayInMilliseconds) {
        this.typer.setTypingSpeed(delayInMilliseconds);
    }

    public int getVisibleLength() {
        return this.visibleLength;
    }

    public boolean isTyping() {
        return this.typing;
    }

    public static AttributedString createAttributedString(String text, Font font, Color color) {
        AttributedString attributedString = new AttributedString(text);
        if (text.length() > 0) {
            attributedString.addAttribute(TextAttribute.FONT, font);
            attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        }
        return attributedString;
    }

    class TypingBehavior
    extends Behavior {
        int START_TYPING = 1;
        WakeupOnBehaviorPost postWakeup = new WakeupOnBehaviorPost((Behavior)this, this.START_TYPING);
        WakeupOnElapsedTime timeWakeup = new WakeupOnElapsedTime(100L);

        TypingBehavior() {
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)new WakeupOnActivation());
        }

        public void type() {
            this.postId(this.START_TYPING);
            LabelOverlay.this.typing = true;
        }

        public void processStimulus(Enumeration criteria) {
            LabelOverlay.this.updateTyping();
            if (LabelOverlay.this.typing) {
                this.wakeupOn((WakeupCondition)this.timeWakeup);
            } else {
                this.wakeupOn((WakeupCondition)this.postWakeup);
            }
        }

        public void setTypingSpeed(long speed) {
            this.timeWakeup = new WakeupOnElapsedTime(speed);
        }
    }
}

