/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.Overlay;
import com.xith.java3d.overlay.OverlayUtilities;
import com.xith.java3d.overlay.ScreenComponent;
import com.xith.java3d.overlay.SubOverlay;
import com.xith.java3d.overlay.UpdateControlBehavior;
import com.xith.java3d.overlay.UpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;

public class OverlayBase
implements Overlay,
ScreenComponent {
    private static final double consoleZ = (double)2.1f;
    protected int backgroundMode = 1;
    protected int[] relativePosition;
    private BufferedImage backgroundImage;
    private boolean hasAlpha;
    private boolean visible;
    private boolean antialiased;
    private Rectangle bounds;
    private Dimension offset;
    private UpdateManager updateManager;
    private Canvas3D canvas3D;
    protected BufferedImage canvas;
    protected SubOverlay[] subOverlay;
    protected int activeBuffer;
    protected BranchGroup consoleBranchGroup;
    protected TransformGroup consoleTransformGroup;
    private RenderingAttributes renderAttributes;
    private PolygonAttributes polygonAttributes;
    private TextureAttributes textureAttributes;
    private TransparencyAttributes transparencyAttributes;
    public static final int VISIBLE = 0;
    public static final int POSITION = 1;
    public static final int ACTIVE_BUFFER = 2;
    private boolean[] dirtyCheck;
    private boolean painting;

    public OverlayBase(Canvas3D canvas3D, Rectangle bounds) {
        this(canvas3D, bounds, true, false, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle bounds, UpdateManager manager) {
        this(canvas3D, bounds, true, false, manager);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle bounds, boolean clipAlpha, boolean blendAlpha) {
        this(canvas3D, bounds, clipAlpha, blendAlpha, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle bounds, boolean clipAlpha, boolean blendAlpha, UpdateManager updateManager) {
        this(canvas3D, bounds, clipAlpha, blendAlpha, updateManager, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayBase(Canvas3D canvas3D, Rectangle bounds, boolean clipAlpha, boolean blendAlpha, UpdateManager updateManager, int numBuffers) {
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.relativePosition = nArray;
        this.subOverlay = new SubOverlay[0];
        this.activeBuffer = -1;
        this.dirtyCheck = new boolean[3];
        this.painting = false;
        this.canvas3D = canvas3D;
        this.visible = true;
        this.antialiased = true;
        this.bounds = bounds;
        this.offset = new Dimension(bounds.x, bounds.y);
        this.hasAlpha = clipAlpha || blendAlpha;
        this.canvas = OverlayUtilities.createBufferedImage(bounds.getSize(), this.hasAlpha);
        canvas3D.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OverlayBase.this.dirty(1);
            }
        });
        this.consoleBranchGroup = new BranchGroup();
        this.consoleTransformGroup = new TransformGroup();
        this.consoleTransformGroup.setCapability(18);
        this.consoleBranchGroup.addChild((Node)this.consoleTransformGroup);
        if (updateManager == null) {
            UpdateControlBehavior updateBehavior = new UpdateControlBehavior(this);
            updateBehavior.setSchedulingBounds((Bounds)new BoundingSphere());
            this.consoleBranchGroup.addChild((Node)updateBehavior);
            updateManager = updateBehavior;
        }
        this.updateManager = updateManager;
        this.renderAttributes = new RenderingAttributes();
        if (clipAlpha) {
            this.renderAttributes.setAlphaTestFunction(3);
            this.renderAttributes.setAlphaTestValue(0.0f);
        }
        this.renderAttributes.setDepthBufferEnable(true);
        this.renderAttributes.setDepthBufferWriteEnable(true);
        this.renderAttributes.setIgnoreVertexColors(true);
        this.renderAttributes.setCapability(5);
        this.renderAttributes.setCapability(6);
        this.polygonAttributes = new PolygonAttributes();
        this.polygonAttributes.setBackFaceNormalFlip(false);
        this.polygonAttributes.setCullFace(0);
        this.polygonAttributes.setPolygonMode(2);
        this.textureAttributes = new TextureAttributes();
        this.textureAttributes.setTextureMode(5);
        this.textureAttributes.setPerspectiveCorrectionMode(0);
        if (this.hasAlpha) {
            this.transparencyAttributes = new TransparencyAttributes(2, 1.0f);
            this.textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 1.0f));
        }
        Vector overlays = OverlayUtilities.subdivide(bounds.getSize(), 16, 256);
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            this.subOverlay = new SubOverlay[overlays.size()];
            int n = overlays.size();
            int i = 0;
            while (i < n) {
                Rectangle currentOverlay = (Rectangle)overlays.get(i);
                this.subOverlay[i] = new SubOverlay(this, currentOverlay, numBuffers);
                this.consoleTransformGroup.addChild((Node)this.subOverlay[i].getShape());
                ++i;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.initialize();
            int i2 = this.dirtyCheck.length - 1;
            while (i2 >= 0) {
                this.dirtyCheck[i2] = true;
                --i2;
            }
            this.repaint();
            return;
        }
    }

    protected void initialize() {
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    @Override
    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
        updateManager.updateRequested();
    }

    @Override
    public void setOffset(Dimension offset) {
        this.setOffset(offset.width, offset.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(int width, int height) {
        if (this.offset.width != width || this.offset.height != height) {
            Dimension dimension = this.offset;
            synchronized (dimension) {
                this.offset.width = width;
                this.offset.height = height;
                this.dirty(1);
            }
        }
    }

    @Override
    public void setRelativePosition(int[] relativePositon) {
        this.setRelativePosition(this.relativePosition[0], this.relativePosition[1]);
    }

    @Override
    public void setRelativePosition(int xType, int yType) {
        if (this.relativePosition[0] != xType || this.relativePosition[1] != yType) {
            this.relativePosition[0] = xType;
            this.relativePosition[1] = yType;
            this.dirty(1);
        }
    }

    @Override
    public BranchGroup getRoot() {
        return this.consoleBranchGroup;
    }

    public boolean hasAlphaComponent() {
        return this.hasAlpha;
    }

    @Override
    public void setAntialiased(boolean antialiased) {
        if (this.antialiased != antialiased) {
            this.antialiased = antialiased;
            this.repaint();
        }
    }

    @Override
    public boolean isAntialiased() {
        return this.antialiased;
    }

    @Override
    public Canvas3D getCanvas() {
        return this.canvas3D;
    }

    public RenderingAttributes getRenderingAttributes() {
        return this.renderAttributes;
    }

    public PolygonAttributes getPolygonAttributes() {
        return this.polygonAttributes;
    }

    public TextureAttributes getTextureAttributes() {
        return this.textureAttributes;
    }

    public TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttributes;
    }

    protected Graphics2D getGraphics() {
        if (this.backgroundMode == 1 && this.backgroundImage != null) {
            this.canvas.setData(this.backgroundImage.getRaster());
        }
        Graphics2D g = (Graphics2D)this.canvas.getGraphics();
        if (this.antialiased) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return g;
    }

    public void repaint() {
        if (!this.painting) {
            this.painting = true;
            Graphics2D g = this.getGraphics();
            this.paint(g);
            g.dispose();
            this.updateBuffer(this.canvas, -1);
            this.setActiveBuffer(-1);
            this.painting = false;
        } else {
            System.err.println("Skipped paint in: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuffer(BufferedImage image, int bufferIndex) {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            int i = this.subOverlay.length - 1;
            while (i >= 0) {
                this.subOverlay[i].updateBuffer(image, bufferIndex);
                --i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.dirty(0);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics2D g) {
    }

    protected void setActiveBuffer(int activeBuffer) {
        this.activeBuffer = activeBuffer;
        this.dirty(2);
    }

    public void setBackgroundColor(Color color) {
        int[] pixels = new int[this.bounds.width * this.bounds.height];
        int rgb = color.getRGB();
        int i = pixels.length - 1;
        while (i >= 0) {
            pixels[i] = rgb;
            --i;
        }
        this.getBackgroundImage().setRGB(0, 0, this.bounds.width, this.bounds.height, pixels, 0, this.bounds.width);
        this.repaint();
    }

    public BufferedImage getBackgroundImage() {
        if (this.backgroundImage == null) {
            this.backgroundImage = OverlayUtilities.createBufferedImage(this.bounds.getSize(), this.hasAlpha);
        }
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage backgroundImage) {
        if (this.backgroundImage != backgroundImage) {
            this.backgroundImage = backgroundImage;
            this.repaint();
        }
    }

    public void setBackgroundMode(int mode) {
        if (this.backgroundMode != mode) {
            this.backgroundMode = mode;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPosition() {
        Rectangle rectangle = this.bounds;
        synchronized (rectangle) {
            Dimension canvas3DSize = this.canvas3D.getSize();
            OverlayUtilities.repositonBounds(this.bounds, this.relativePosition, canvas3DSize, this.offset);
            double fov = this.canvas3D.getView().getFieldOfView();
            double consoleWidth = 2.0 * Math.tan(fov / 2.0) * (double)2.1f;
            double scale = consoleWidth / canvas3DSize.getWidth();
            double consoleHeight = canvas3DSize.getHeight() * scale;
            Point flippedPoint = new Point(this.bounds.x, canvas3DSize.height - this.bounds.height - this.bounds.y);
            Transform3D planeOffset = new Transform3D();
            planeOffset.setTranslation(new Vector3d(-consoleWidth / 2.0 + flippedPoint.getX() * scale, -consoleHeight / 2.0 + flippedPoint.getY() * scale, (double)-2.1f));
            planeOffset.setScale(scale);
            this.consoleTransformGroup.setTransform(planeOffset);
            this.dirtyCheck[1] = false;
        }
    }

    private void syncVisible() {
        this.renderAttributes.setVisible(this.visible);
        this.dirtyCheck[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncActiveBuffer() {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            int i = this.subOverlay.length - 1;
            while (i >= 0) {
                this.subOverlay[i].setActiveBufferIndex(this.activeBuffer);
                --i;
            }
            this.dirtyCheck[2] = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void dirty(int property) {
        this.dirtyCheck[property] = true;
        if (this.updateManager != null) {
            this.updateManager.updateRequested();
        } else {
            System.err.println("Null update manager in: " + this);
        }
    }

    @Override
    public void update() {
        if (this.dirtyCheck[1]) {
            this.syncPosition();
        }
        if (this.dirtyCheck[0]) {
            this.syncVisible();
        }
        if (this.dirtyCheck[2]) {
            this.syncActiveBuffer();
        }
    }
}

