/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;

public class OverlayUtilities {
    public static BufferedImage createBufferedImage(Dimension size, boolean hasAlpha) {
        int numBytes = hasAlpha ? 4 : 3;
        int[] numBit = new int[numBytes];
        int[] bandOffset = new int[numBytes];
        int i = 0;
        while (i < numBytes) {
            numBit[i] = 8;
            bandOffset[i] = i;
            ++i;
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int transparencyType = hasAlpha ? 3 : 1;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, numBit, hasAlpha, false, transparencyType, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, size.width, size.height, size.width * numBytes, numBytes, bandOffset, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage[] loadImages(URL[] filename, Component observer, boolean alphaInImage) {
        return OverlayUtilities.loadImages(filename, observer, alphaInImage, new Dimension());
    }

    public static BufferedImage[] loadImages(URL[] filename, Component observer, boolean alphaInImage, Dimension maxSize) {
        BufferedImage[] buffer = new BufferedImage[filename.length];
        MediaTracker tracker = new MediaTracker(observer);
        int id = 0;
        int timeout = 5000;
        int i = filename.length - 1;
        while (i >= 0) {
            if (filename[i] != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(filename[i]);
                tracker.addImage(image, id);
                try {
                    tracker.waitForID(id, timeout);
                }
                catch (InterruptedException e) {
                    System.err.println("Error: " + filename[i] + " interrupted while loading");
                }
                tracker.removeImage(image, id);
                Dimension imageSize = new Dimension(image.getWidth(observer), image.getHeight(observer));
                maxSize.width = Math.max(maxSize.width, imageSize.width);
                maxSize.height = Math.max(maxSize.height, imageSize.height);
                buffer[i] = OverlayUtilities.createBufferedImage(imageSize, alphaInImage);
                ((Graphics2D)buffer[i].getGraphics()).drawImage(image, null, observer);
            }
            --i;
        }
        return buffer;
    }

    public static void setBackgroundColor(OverlayBase[] overlay, Color backgroundColor) {
        int i = 0;
        i = overlay.length - 1;
        while (i >= 0) {
            overlay[i].getUpdateManager().setUpdating(false);
            overlay[i].setBackgroundColor(backgroundColor);
            --i;
        }
        i = overlay.length - 1;
        while (i >= 0) {
            overlay[i].getUpdateManager().setUpdating(true);
            --i;
        }
    }

    public static Vector subdivide(Dimension dimension, int threshhold, int max) {
        Vector cols = OverlayUtilities.components(dimension.width, threshhold, max);
        Vector rows = OverlayUtilities.components(dimension.height, threshhold, max);
        Vector<Rectangle> parts = new Vector<Rectangle>();
        int i = 0;
        int j = 0;
        int x = 0;
        int y = 0;
        i = 0;
        while (i < rows.size()) {
            j = 0;
            x = 0;
            while (j < cols.size()) {
                parts.add(new Rectangle(x, y, (Integer)cols.get(j), (Integer)rows.get(i)));
                x += ((Integer)cols.get(j)).intValue();
                ++j;
            }
            y += ((Integer)rows.get(i)).intValue();
            ++i;
        }
        return parts;
    }

    public static Vector components(int value, int threshhold, int max) {
        Vector<Integer> components = new Vector<Integer>();
        while (value > 0) {
            int p = Math.min(OverlayUtilities.optimalPower(value, threshhold, max), value);
            components.add(new Integer(p));
            value -= p;
        }
        return components;
    }

    public static int optimalPower(int value, int threshhold, int max) {
        int optimal = 1;
        value = Math.min(value, max);
        while (optimal * 2 - value <= threshhold) {
            optimal *= 2;
        }
        return optimal;
    }

    public static int smallestPower(int value) {
        int n = 1;
        while (n < value) {
            n *= 2;
        }
        return n;
    }

    public static Shape3D buildShape(Appearance appearance, Rectangle bounds) {
        Texture texture = appearance.getTexture();
        QuadArray planeGeometry = new QuadArray(4, texture == null ? 1 : 33);
        float[] verticies = new float[]{bounds.x + bounds.width, bounds.y, 0.0f, bounds.x + bounds.width, bounds.y + bounds.height, 0.0f, bounds.x, bounds.y + bounds.height, 0.0f, bounds.x, bounds.y, 0.0f};
        planeGeometry.setCoordinates(0, verticies);
        if (texture != null) {
            Point2D.Float textureRatio = new Point2D.Float((float)(bounds.getWidth() / (double)texture.getWidth()), (float)(bounds.getHeight() / (double)texture.getHeight()));
            float[] textureCoordinates = new float[]{textureRatio.x, 0.0f, textureRatio.x, textureRatio.y, 0.0f, textureRatio.y, 0.0f, 0.0f};
            planeGeometry.setTextureCoordinates(0, 0, textureCoordinates);
        }
        Shape3D shape = new Shape3D();
        shape.setGeometry((Geometry)planeGeometry);
        shape.setAppearance(appearance);
        return shape;
    }

    public static void repositonBounds(Rectangle bounds, int[] relativePosition, Dimension canvasSize, Dimension offset) {
        switch (relativePosition[0]) {
            case 0: {
                bounds.x = canvasSize.width - bounds.width - offset.width;
                break;
            }
            case 1: {
                bounds.x = offset.width;
                break;
            }
            case 3: {
                bounds.x = canvasSize.width / 2 - bounds.width / 2 - offset.width;
            }
        }
        switch (relativePosition[1]) {
            case 0: {
                bounds.y = offset.height;
                break;
            }
            case 1: {
                bounds.y = canvasSize.height - bounds.height - offset.height;
                break;
            }
            case 3: {
                bounds.y = canvasSize.height / 2 - bounds.height / 2 - offset.height;
            }
        }
    }
}

