/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import com.xith.java3d.overlay.OverlayUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;

class SubOverlay {
    public static final int NEXT_BUFFER = -1;
    BufferedImage[] buffer;
    ImageComponent2D[] bufferHolder;
    int numBuffers;
    int activeBufferIndex = 0;
    Texture2D texture;
    Shape3D shape;
    OverlayBase overlay;
    Rectangle space;
    int[] transferBuffer;

    protected SubOverlay(OverlayBase overlay, Rectangle space) {
        this(overlay, space, 2);
    }

    protected SubOverlay(OverlayBase overlay, Rectangle space, int numBuffers) {
        this.overlay = overlay;
        this.space = space;
        this.numBuffers = numBuffers;
        this.buffer = new BufferedImage[numBuffers];
        this.bufferHolder = new ImageComponent2D[numBuffers];
        this.transferBuffer = new int[space.width];
        boolean hasAlpha = overlay.hasAlphaComponent();
        int imageComponentType = hasAlpha ? 2 : 1;
        Dimension textureSize = new Dimension(OverlayUtilities.smallestPower(space.width), OverlayUtilities.smallestPower(space.height));
        int i = numBuffers - 1;
        while (i >= 0) {
            this.buffer[i] = OverlayUtilities.createBufferedImage(textureSize, hasAlpha);
            this.bufferHolder[i] = new ImageComponent2D(imageComponentType, this.buffer[i], true, true);
            --i;
        }
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(overlay.getPolygonAttributes());
        appearance.setRenderingAttributes(overlay.getRenderingAttributes());
        appearance.setTextureAttributes(overlay.getTextureAttributes());
        appearance.setTransparencyAttributes(overlay.getTransparencyAttributes());
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        this.texture = new Texture2D(1, hasAlpha ? 6 : 5, textureSize.width, textureSize.height);
        this.texture.setBoundaryModeS(2);
        this.texture.setBoundaryModeT(2);
        this.texture.setMagFilter(0);
        this.texture.setMinFilter(0);
        this.texture.setImage(0, (ImageComponent)this.bufferHolder[this.activeBufferIndex]);
        this.texture.setCapability(7);
        appearance.setTexture((Texture)this.texture);
        this.shape = SubOverlay.buildShape(appearance, space);
    }

    public static int smallestPower(int value) {
        int n = 1;
        while (n < value) {
            n *= 2;
        }
        return n;
    }

    public static Shape3D buildShape(Appearance appearance, Rectangle space) {
        Texture texture = appearance.getTexture();
        QuadArray planeGeometry = new QuadArray(4, texture == null ? 1 : 33);
        float[] verticies = new float[]{space.x + space.width, space.y, 0.0f, space.x + space.width, space.y + space.height, 0.0f, space.x, space.y + space.height, 0.0f, space.x, space.y, 0.0f};
        planeGeometry.setCoordinates(0, verticies);
        if (texture != null) {
            Point2D.Float textureRatio = new Point2D.Float((float)(space.getWidth() / (double)texture.getWidth()), (float)(space.getHeight() / (double)texture.getHeight()));
            float[] textureCoordinates = new float[]{textureRatio.x, 0.0f, textureRatio.x, textureRatio.y, 0.0f, textureRatio.y, 0.0f, 0.0f};
            planeGeometry.setTextureCoordinates(0, 0, textureCoordinates);
        }
        Shape3D shape = new Shape3D();
        shape.setGeometry((Geometry)planeGeometry);
        shape.setAppearance(appearance);
        return shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuffer(BufferedImage fullOverlayImage, int bufferIndex) {
        Dimension size = new Dimension(fullOverlayImage.getWidth(), fullOverlayImage.getHeight());
        if (bufferIndex == -1) {
            bufferIndex = this.getNextBufferIndex();
        }
        BufferedImage bufferedImage = this.buffer[bufferIndex];
        synchronized (bufferedImage) {
            int scanLine = 0;
            while (scanLine < this.space.height) {
                fullOverlayImage.getRGB(this.space.x, size.height - this.space.y - this.space.height + scanLine, this.transferBuffer.length, 1, this.transferBuffer, 0, size.width);
                this.buffer[bufferIndex].setRGB(0, this.space.height - scanLine - 1, this.transferBuffer.length, 1, this.transferBuffer, 0, size.width);
                ++scanLine;
            }
        }
    }

    public int getNextBufferIndex() {
        return (this.activeBufferIndex + 1) % this.numBuffers;
    }

    public void setActiveBufferIndex(int activeBufferIndex) {
        if (activeBufferIndex == -1) {
            activeBufferIndex = this.getNextBufferIndex();
        }
        if (this.activeBufferIndex != activeBufferIndex) {
            this.activeBufferIndex = activeBufferIndex;
            this.texture.setImage(0, (ImageComponent)this.bufferHolder[activeBufferIndex]);
        }
    }

    public Shape3D getShape() {
        return this.shape;
    }
}

