/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractPickableObj;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.ctrl.SynthLayerPickingCtrl;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;

public abstract class AbstractLayerPickingCtrl
extends AbstractPickableObj {
    private static boolean _keyListenerAdded = false;

    public AbstractLayerPickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
        if (!_keyListenerAdded) {
            this._coreCtrl.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode == 27 || keyCode == 10) {
                        AbstractLayerPickingCtrl.this._pickCtrl.getLayerPickingCtrl().cancelGraphCreation();
                    } else if (keyCode >= 49 && keyCode <= 57 && (AbstractLayerPickingCtrl.this._pickCtrl.getState() == 1 || AbstractLayerPickingCtrl.this._pickCtrl.getState() == 0)) {
                        AbstractLayerPickingCtrl.this.instrumentSelect(keyCode - 49);
                    }
                }
            });
            _keyListenerAdded = true;
        }
    }

    protected void instrumentSelect(int index) {
        if (this._coreCtrl.getCurrLayer().getType() == 1 && this._pickCtrl.getCurrGraph() != null && this._pickCtrl.getCurrGraph().size() < 2) {
            return;
        }
        try {
            this._pickCtrl.setCurrInstrument(SceneCore.getInstrCabinet().get(this._coreCtrl.getCurrLayer().getType(), index));
            if (this._pickCtrl.getState() == 1) {
                this._pickCtrl.getCurrGraphLine().changePointerInstrument(this._pickCtrl.getCurrInstrument());
                if (this._coreCtrl.getCurrLayer().getType() == 1) {
                    ((SynthLayerPickingCtrl)this._pickCtrl.getLayerPickingCtrl()).changeSynthObjInstr(this._pickCtrl.getCurrGraphLine().getPointerObj());
                }
            }
            if (this._coreCtrl.getHUD() != null) {
                this._coreCtrl.getHUD().updateInstrChoice(index);
            }
            if (this._pickCtrl.getCurrInstrument().needsKeyboard()) {
                this._coreCtrl.getGround().showKeyboard();
            } else {
                this._coreCtrl.getGround().hideKeyboard();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public boolean clicked(Node pickedObj, Point3f intercept, int mouseState) {
        if (this._pickCtrl.getCurrGraphLine() == null) {
            this.createNewGraph(intercept);
        } else if (mouseState == 1) {
            this.cleanUp();
            this.finishGraph(intercept);
        } else {
            this.addObjectToGraph(intercept);
        }
        return true;
    }

    @Override
    public boolean dragged(Point3f intercept, int mouseState) {
        return true;
    }

    @Override
    public boolean released(Point3f intercept, int mouseState) {
        return true;
    }

    protected abstract void createNewGraph(Point3f var1);

    protected abstract void addObjectToGraph(Point3f var1);

    protected abstract void finishGraph(Point3f var1);

    public abstract void cancelGraphCreation();

    protected void startMouseOver(AbstractGraphLine graphLine, SynthObj pointerObj, Point3f intercept) {
        graphLine.initLine(intercept, pointerObj);
        this._coreCtrl.getCanvas3D().addMouseWheelListener(this._mouseWheelListener);
    }

    protected void stopMouseOver(Point3f intercept) {
        this._pickCtrl.getCurrGraphLine().releaseMove(intercept);
        this._pickCtrl.resetCurrValues();
        this._coreCtrl.getCanvas3D().removeMouseWheelListener(this._mouseWheelListener);
    }

    protected void cleanUp() {
    }
}

