/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.io.IOException;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.ctrl.SynthObjAttribCtrl;
import net.mkonrad.synes.data.AbstractGraph;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthInstrument;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCoreOSC;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.synth.SynthExt;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public abstract class AbstractPickableObj {
    protected CentralPickingCtrl _pickCtrl;
    protected SceneCoreOSC _coreCtrl;
    protected SynthObj _selectedSynthObj = null;
    protected AbstractGraphLine _selectedGraphLine = null;
    protected SynthObjAttribCtrl _mouseWheelListener;

    public AbstractPickableObj(CentralPickingCtrl pickCtrl) {
        this._pickCtrl = pickCtrl;
        this._coreCtrl = this._pickCtrl.getCoreCtrl();
        this._mouseWheelListener = new SynthObjAttribCtrl(this);
    }

    public CentralPickingCtrl getPickCtrl() {
        return this._pickCtrl;
    }

    public SynthObj getSelectedSynthObj() {
        return this._selectedSynthObj;
    }

    public AbstractGraphLine getSelectedGraphLine() {
        return this._selectedGraphLine;
    }

    protected void startEditMode() {
        this._coreCtrl.getCanvas3D().addMouseWheelListener(this._mouseWheelListener);
        this._pickCtrl.setState(4);
    }

    protected void stopEditMode() {
        this._coreCtrl.getCanvas3D().removeMouseWheelListener(this._mouseWheelListener);
        this._pickCtrl.setState(0);
    }

    public void changeSynthObjAmp(int byValue) {
        SynthObj synthObj;
        AbstractGraphLine graphLine;
        int layerType = this._coreCtrl.getCurrLayer().getType();
        if (this._pickCtrl.getState() == 1) {
            graphLine = this._pickCtrl.getCurrGraphLine();
            synthObj = (SynthObj)this._pickCtrl.getCurrGraph().get(this._pickCtrl.getCurrGraph().size() - 1);
            graphLine.hidePointerShape();
        } else {
            synthObj = this._pickCtrl.getSynthObjPickingCtrl().getSelectedSynthObj();
            graphLine = this._pickCtrl.getSynthObjPickingCtrl().getSelectedGraphLine();
        }
        float newAmp = synthObj.getAmp() + (float)byValue * 0.025f;
        if (newAmp <= 0.0f) {
            newAmp = 0.0f;
        } else if (newAmp > 1.0f) {
            newAmp = 1.0f;
        }
        DbgTools.print("changed to new amp: " + newAmp);
        synthObj.setAmp(newAmp);
        boolean isMod = false;
        if (layerType == 1) {
            isMod = this.sendSynthAmpChange(synthObj);
        }
        synthObj.getInstrumentShape().rescale();
        Beat connectedPrevObj = null;
        Beat connectedNextObj = null;
        if (layerType == 0) {
            connectedPrevObj = ((Beat)synthObj).getPrevBeat();
            connectedNextObj = ((Beat)synthObj).getNextBeat();
        }
        if (!isMod) {
            if (layerType == 0) {
                if (connectedPrevObj != null) {
                    graphLine.updateLinePoints((SynthObj)connectedPrevObj, synthObj);
                }
                if (connectedNextObj != null) {
                    graphLine.updateLinePoints(synthObj, connectedNextObj);
                }
            } else {
                graphLine.updateLinePoints(null, synthObj);
            }
        } else {
            AbstractGraph graph = graphLine.getGraph();
            int i = 0;
            while (i < graph.size()) {
                SynthObj lineObj = ((SynthGraph)graph).getSynthObj(i);
                if (lineObj != synthObj) {
                    graphLine.updateLinePoints(null, lineObj);
                }
                ++i;
            }
        }
        graphLine.updateGeometry();
    }

    private boolean sendSynthAmpChange(SynthObj synthObj) {
        boolean isMod = false;
        if (synthObj.getSynth() != null) {
            try {
                if (this._coreCtrl.isOSCMode()) {
                    synthObj.getSynth().set("amp", synthObj.getInstrument().getValueForArg("amp", synthObj));
                }
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
        } else {
            Modulator mod = null;
            try {
                mod = (Modulator)synthObj;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (mod != null) {
                AbstractGraph graph;
                isMod = true;
                SynthObj synthObjToMod = null;
                AbstractGraph abstractGraph = graph = mod.getGraph() != null ? mod.getGraph() : this._pickCtrl.getCurrGraph();
                if (this._coreCtrl.isOSCMode()) {
                    try {
                        int i = 0;
                        while (i < graph.size()) {
                            if (graph.get(i) != mod && (synthObjToMod = (SynthObj)graph.get(i)).getSynth() != null) {
                                synthObjToMod.getSynth().set("modAmp", ((SynthInstrument)synthObjToMod.getInstrument()).getModValueForArg("modAmp", synthObjToMod, mod));
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        ErrTools.print(e);
                    }
                }
            }
        }
        return isMod;
    }

    public void playSynthGraph(SynthGraph synthGraph) {
        Modulator mod = synthGraph.getModulator();
        int i = 0;
        while (i < synthGraph.size()) {
            SynthObj synthToPlay = synthGraph.getSynthObj(i);
            if (synthToPlay != mod) {
                this.playSynth(synthToPlay);
            }
            ++i;
        }
    }

    public void releaseSynthGraph(SynthGraph synthGraph) {
        Modulator mod = synthGraph.getModulator();
        int i = 0;
        while (i < synthGraph.size()) {
            SynthObj synthToStop = synthGraph.getSynthObj(i);
            if (synthToStop != mod && synthToStop.getSynth() != null) {
                try {
                    DbgTools.print("Releasing SynthObj#" + synthToStop.getId());
                    synthToStop.getSynth().releaseWithin(10);
                    synthToStop.setSynth(null);
                }
                catch (IOException e) {
                    ErrTools.print(e);
                }
            }
            ++i;
        }
    }

    public void playSynth(SynthObj synthObj) {
        DbgTools.print("Playing SynthObj#" + synthObj.getId() + " in group#" + this._coreCtrl.getCurrLayer().getSCGroup().getNodeID());
        try {
            SynthExt synth = SynthExt.basicNew(this._coreCtrl.getSCServer(), this._coreCtrl.getCurrLayer().getSCGroup(), synthObj);
            Modulator mod = null;
            if (synthObj.getGraph() != null) {
                ((SynthGraph)synthObj.getGraph()).getModulator();
            }
            if (mod == null) {
                synth.play(synthObj.getInstrument().getSynthArgs(), synthObj.getInstrument().getAllSynthValues(synthObj));
            } else {
                synth.play(synthObj.getInstrument().getModArgs(), ((SynthInstrument)synthObj.getInstrument()).getAllModValues(synthObj, mod));
            }
            synthObj.setSynth(synth);
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
    }

    public abstract boolean clicked(Node var1, Point3f var2, int var3);

    public abstract boolean moved(Node var1, Point3f var2, int var3);

    public abstract boolean dragged(Point3f var1, int var2);

    public abstract boolean released(Point3f var1, int var2);
}

