/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.io.IOException;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractPickableObj;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.BeatGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.elements.BeatGraphLine;
import net.mkonrad.synes.synth.SynthExt;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class BeatPickingCtrl
extends AbstractPickableObj {
    SynthExt _playingSynthExt = null;

    public BeatPickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
    }

    @Override
    public boolean clicked(Node pickedObj, Point3f intercept, int mouseState) {
        Beat beat = (Beat)pickedObj.getUserData();
        if (this._pickCtrl.getState() == 1) {
            return this.handleBeatGraphCreation(beat, intercept);
        }
        if (this._pickCtrl.getMouseEvent().isControlDown()) {
            this._pickCtrl.setState(2);
            return this.handleImprovBeatStart(beat, intercept);
        }
        if (this._pickCtrl.getState() == 0) {
            this._selectedSynthObj = (SynthObj)pickedObj.getUserData();
            this._selectedGraphLine = this._selectedSynthObj.getGraph().getGraphLine();
            this.startEditMode();
        }
        return true;
    }

    @Override
    public boolean dragged(Point3f intercept, int mouseState) {
        if (this._pickCtrl.getState() == 2 && this._pickCtrl.getMouseEvent().isControlDown()) {
            this._pickCtrl.setState(2);
            return this.handleImprovBeatMod(intercept);
        }
        if (this._pickCtrl.getState() == 4) {
            this._selectedSynthObj.getInstrumentShape().setPos(intercept);
            this._selectedGraphLine.movedObj(this._selectedSynthObj);
        }
        return true;
    }

    @Override
    public boolean moved(Node pickedObj, Point3f where, int mouseState) {
        return false;
    }

    @Override
    public boolean released(Point3f intercept, int mouseState) {
        if (this._pickCtrl.getState() == 2) {
            this.handleImprovBeatStop();
            this._pickCtrl.setState(0);
        } else if (this._pickCtrl.getState() == 4) {
            if (this._coreCtrl.isOSCMode()) {
                this._coreCtrl.getSCLang().sendOSCDataOneByOne("/change", ((Beat)this._selectedSynthObj).generateOSCUpdate());
            }
            this._selectedSynthObj = null;
            this._selectedGraphLine = null;
            this.stopEditMode();
        }
        return true;
    }

    private boolean handleImprovBeatStart(Beat beat, Point3f intercept) {
        try {
            this._pickCtrl.pauseBeatGraph((BeatGraph)beat.getGraph());
            this._playingSynthExt = SynthExt.basicNew(this._coreCtrl.getSCServer(), this._coreCtrl.getSCStdGrp(), beat);
            this._playingSynthExt.play(beat.getInstrument().getSynthArgs(), beat.getInstrument().getAllSynthValues(beat));
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
        return true;
    }

    private boolean handleImprovBeatMod(Point3f intercept) {
        try {
            this._playingSynthExt.modSeqSynth(intercept);
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
        return true;
    }

    private boolean handleImprovBeatStop() {
        if (this._playingSynthExt != null) {
            try {
                this._playingSynthExt.release();
                this._pickCtrl.resumeBeatGraph((BeatGraph)this._playingSynthExt.getSynthObj().getGraph());
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
            this._playingSynthExt = null;
        }
        return true;
    }

    private boolean handleBeatGraphCreation(Beat beat, Point3f intercept) {
        BeatGraph beatGraph = (BeatGraph)this._pickCtrl.getCurrGraphLine().getGraph();
        if (beat == beatGraph.get(0)) {
            if (beatGraph.size() > 2) {
                ((BeatGraphLine)this._pickCtrl.getCurrGraphLine()).closeBeatGraph();
                this._pickCtrl.getLayerPickingCtrl().finishGraph(intercept);
                DbgTools.print("Closed beatgraph");
            }
        } else if (beat == beatGraph.get(beatGraph.size() - 1)) {
            this._pickCtrl.getCurrGraphLine().cleanUpTail();
            this._pickCtrl.getLayerPickingCtrl().finishGraph(intercept);
        }
        return true;
    }
}

