/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import net.mkonrad.synes.gui.elements.BeatGraphLine;

public class BeatTimingBehavior
extends Behavior {
    private WakeupOnElapsedTime _timeOut = null;
    private BeatGraphLine _graphLine;
    private long _lastStimulus = 0L;
    private long _lastBeat = 0L;

    public BeatTimingBehavior(BeatGraphLine graphLine, long timeDelay) {
        this._graphLine = graphLine;
        this.setTimeDelay(timeDelay);
    }

    public void reinit() {
        this._lastStimulus = 0L;
        this._lastBeat = 0L;
    }

    public void setTimeDelay(long timeDelay) {
        this._timeOut = timeDelay > 0L ? new WakeupOnElapsedTime(timeDelay) : null;
    }

    public void initialize() {
        if (this._timeOut != null) {
            this.wakeupOn((WakeupCondition)this._timeOut);
        }
    }

    public void processStimulus(Enumeration criteria) {
        long origTime;
        long nextBeat = origTime = this._graphLine.beat();
        if (this._lastStimulus > 0L && this._lastBeat > 0L && (nextBeat -= System.currentTimeMillis() - this._lastStimulus - this._lastBeat) < 0L) {
            nextBeat = origTime + nextBeat;
        }
        this.setTimeDelay(nextBeat);
        if (this._timeOut != null) {
            this.wakeupOn((WakeupCondition)this._timeOut);
        }
        this._lastBeat = nextBeat;
        this._lastStimulus = System.currentTimeMillis();
    }

    public void resumeIn(long resumeMs) {
        this.setEnable(true);
        this.setTimeDelay(resumeMs);
    }
}

