/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import de.sciss.net.OSCMessage;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractLayerPickingCtrl;
import net.mkonrad.synes.ctrl.AbstractLinePickingCtrl;
import net.mkonrad.synes.ctrl.AbstractPickableObj;
import net.mkonrad.synes.ctrl.BeatPickingCtrl;
import net.mkonrad.synes.ctrl.BeatTimingBehavior;
import net.mkonrad.synes.ctrl.SeqLayerPickingCtrl;
import net.mkonrad.synes.ctrl.SeqLinePickingCtrl;
import net.mkonrad.synes.ctrl.SynthLayerPickingCtrl;
import net.mkonrad.synes.ctrl.SynthLinePickingCtrl;
import net.mkonrad.synes.ctrl.SynthObjPickingCtrl;
import net.mkonrad.synes.data.AbstractGraph;
import net.mkonrad.synes.data.BeatGraph;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.LayerSet;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.SceneCoreOSC;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.gui.elements.BeatGraphLine;
import net.mkonrad.synes.gui.elements.GroundShape;
import net.mkonrad.synes.gui.elements.SynthGraphLine;
import net.mkonrad.synes.osc.OSCMsgProcessor;
import net.mkonrad.synes.util.Common3DTools;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.MusicTools;

public class CentralPickingCtrl
extends PickMouseBehavior
implements OSCMsgProcessor {
    public static final int MOUSE_NOCLICK = -1;
    public static final int MOUSE_ONECLICK = 0;
    public static final int MOUSE_DBLCLICK = 1;
    public static final int MOUSE_DRAGGING = 2;
    public static final int MOUSE_RELEASED = 3;
    public static final int STATE_READY = 0;
    public static final int STATE_GRAPH_CREATE = 1;
    public static final int STATE_BEAT_IMPRO = 2;
    public static final int STATE_GRAPH_PAUSED = 3;
    public static final int STATE_GRAPH_EDIT = 4;
    public static final int STATE_GRAPH_MOVE = 5;
    private LayerSet _layers;
    private SceneCoreOSC _coreCtrl;
    private int _currentGraphId = -1;
    private AbstractGraphLine _currGraphLine = null;
    private SeqLayerPickingCtrl _seqLayerPickingCtrl;
    private SynthLayerPickingCtrl _synthLayerPickingCtrl;
    private SeqLinePickingCtrl _seqLinePickingCtrl;
    private SynthLinePickingCtrl _synthLinePickingCtrl;
    private BeatPickingCtrl _beatPickingCtrl;
    private SynthObjPickingCtrl _synthPickingCtrl;
    private AbstractLayerPickingCtrl _layerPickingCtrl;
    private AbstractPickableObj _synthObjPickingCtrl;
    private AbstractLinePickingCtrl _linePickingCtrl;
    private int _mouseState = -1;
    private int _state = 0;
    private Object _notify = new Object();
    private Instrument _currInstrument;

    public CentralPickingCtrl(BranchGroup root, SceneCore coreCtrl) {
        super((Canvas3D)coreCtrl.getCanvas3D(), root, SceneCore.getSceneBounds());
        this.setSchedulingBounds(SceneCore.getSceneBounds());
        this._layers = coreCtrl.getLayerSet();
        this._coreCtrl = (SceneCoreOSC)coreCtrl;
        this._seqLayerPickingCtrl = new SeqLayerPickingCtrl(this);
        this._synthLayerPickingCtrl = new SynthLayerPickingCtrl(this);
        this._seqLinePickingCtrl = new SeqLinePickingCtrl(this);
        this._synthLinePickingCtrl = new SynthLinePickingCtrl(this);
        this._beatPickingCtrl = new BeatPickingCtrl(this);
        this._synthPickingCtrl = new SynthObjPickingCtrl(this);
        this._layerPickingCtrl = this._seqLayerPickingCtrl;
        this._synthObjPickingCtrl = this._beatPickingCtrl;
        this._linePickingCtrl = this._seqLinePickingCtrl;
        this._layerPickingCtrl.instrumentSelect(0);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(0.0f);
    }

    public int getState() {
        return this._state;
    }

    public void setState(int state) {
        this._state = state;
    }

    public int getMouseState() {
        return this._mouseState;
    }

    public AbstractLayerPickingCtrl getLayerPickingCtrl() {
        return this._layerPickingCtrl;
    }

    public AbstractPickableObj getSynthObjPickingCtrl() {
        return this._synthObjPickingCtrl;
    }

    public AbstractLinePickingCtrl getLinePickingCtrl() {
        return this._linePickingCtrl;
    }

    public SynthLayerPickingCtrl getSynthLayerPickingCtrl() {
        return this._synthLayerPickingCtrl;
    }

    public BeatGraphLine createGraphLine(BeatGraph graph) {
        this._currGraphLine = new BeatGraphLine(this._coreCtrl);
        this._currGraphLine.initGraph(graph);
        graph.setGraphLine(this._currGraphLine);
        return (BeatGraphLine)this._currGraphLine;
    }

    public SynthGraphLine createGraphLine(SynthGraph graph) {
        this._currGraphLine = new SynthGraphLine(this._coreCtrl);
        this._currGraphLine.initGraph(graph);
        graph.setGraphLine(this._currGraphLine);
        return (SynthGraphLine)this._currGraphLine;
    }

    public void addNewGraphElementsToScene(Node node) {
        if (this._currGraphLine.getBG().getParent() == null) {
            this._coreCtrl.getCurrLayer().getLayerTG().addChild((Node)this._currGraphLine.getBG());
        }
        this._currGraphLine.getTG().addChild(node);
    }

    public void initialize() {
        this.conditions = new WakeupCriterion[4];
        this.conditions[0] = new WakeupOnAWTEvent(503);
        this.conditions[1] = new WakeupOnAWTEvent(501);
        this.conditions[2] = new WakeupOnAWTEvent(506);
        this.conditions[3] = new WakeupOnAWTEvent(502);
        this.wakeupCondition = new WakeupOr(this.conditions);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        this._mouseState = -1;
        if (evt.getID() == 501) {
            this.buttonPress = true;
            this._mouseState = 0;
            if (evt.getClickCount() >= 2) {
                this._mouseState = 1;
            }
            return;
        }
        if (evt.getID() == 506) {
            this._mouseState = 2;
            return;
        }
        if (evt.getID() == 502) {
            this.buttonPress = false;
            this._mouseState = 3;
            return;
        }
        if (evt.getID() == 503) {
            return;
        }
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xpos = this.mevent.getPoint().x;
            ypos = this.mevent.getPoint().y;
        }
        if (this.buttonPress || this._state != 0) {
            this.updateScene(xpos, ypos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void updateScene(int posX, int posY) {
        this.pickCanvas.setShapeLocation(posX, posY);
        Point3d eyePos = this.pickCanvas.getStartPosition();
        PickResult pickResult = this.pickCanvas.pickClosest();
        if (pickResult != null) {
            PickIntersection pickedIntersect = pickResult.getClosestIntersection(eyePos);
            if (pickedIntersect == null) {
                return;
            }
            Point3f intercept = new Point3f(pickedIntersect.getPointCoordinatesVW());
            Primitive pickedPrimitive = (Primitive)pickResult.getNode(4);
            Shape3D pickedShape = null;
            if (pickedPrimitive == null) {
                pickedShape = (Shape3D)pickResult.getNode(1);
            }
            boolean dontFallBackToLayer = false;
            if (this._mouseState == 0 || this._mouseState == 1) {
                if (pickedPrimitive != null && pickedPrimitive.getUserData() instanceof SynthObj) {
                    if (this._coreCtrl.isOrbitMode()) {
                        this.switchToLayer(pickedPrimitive);
                    }
                    dontFallBackToLayer = this._synthObjPickingCtrl.clicked((Node)pickedPrimitive, intercept, this._mouseState);
                } else if (pickedShape instanceof AbstractGraphLine) {
                    if (this._coreCtrl.isOrbitMode()) {
                        this.switchToLayer(pickedShape);
                    }
                    dontFallBackToLayer = this._linePickingCtrl.clicked((Node)pickedShape, intercept, this._mouseState);
                }
            } else if (this._mouseState == 2) {
                this._coreCtrl.disableOrbitCtrl();
                if (this._state == 2 || this._state == 4) {
                    dontFallBackToLayer = this._synthObjPickingCtrl.dragged(intercept, this._mouseState);
                } else if (this._state == 5) {
                    dontFallBackToLayer = this._linePickingCtrl.dragged(intercept, this._mouseState);
                }
            } else if (this._mouseState == 3) {
                if (this._state == 2 || this._state == 4) {
                    dontFallBackToLayer = this._synthObjPickingCtrl.released(intercept, this._mouseState);
                } else if (this._state == 3 || this._state == 5) {
                    dontFallBackToLayer = this._linePickingCtrl.released(intercept, this._mouseState);
                }
                this._coreCtrl.enableOrbitCtrl();
            }
            if (pickedShape instanceof GroundShape || !dontFallBackToLayer) {
                if (this._mouseState == -1) {
                    this._layerPickingCtrl.moved((Node)pickedShape, intercept, this._mouseState);
                } else if (!dontFallBackToLayer && this.buttonPress) {
                    this._layerPickingCtrl.clicked((Node)pickedShape, intercept, this._mouseState);
                }
            }
        }
    }

    private void switchToLayer(Object pickedObj) {
        int newLayer = -1;
        Instrument instr = null;
        if (pickedObj instanceof Primitive) {
            SynthObj synthObj = (SynthObj)((Primitive)pickedObj).getUserData();
            newLayer = synthObj.getGraph().getLayerLevel();
            instr = synthObj.getInstrument();
        } else if (pickedObj instanceof AbstractGraphLine) {
            newLayer = ((AbstractGraphLine)((Object)pickedObj)).getGraph().getLayerLevel();
        }
        if (newLayer > -1 && newLayer != this._coreCtrl.getLayerSet().getCurrLayerLevel()) {
            DbgTools.print("Switch to new layer: " + newLayer);
            this._coreCtrl.changeLayer(newLayer, null);
            this._coreCtrl.getHUD().updateLayerInfo();
            this._coreCtrl.getHUD().updateAvailableInstr();
        }
        if (instr != null) {
            DbgTools.print("Switch to new instrument: " + instr.getName());
            if (instr.getName() != null) {
                this._layerPickingCtrl.instrumentSelect(instr.getKey() - 1);
            } else {
                this._coreCtrl.getGround().hideKeyboard();
            }
        }
    }

    @Override
    public boolean canHandleOSCMsg(String name) {
        return name.equals("/startBeatGraph") || name.equals("/resumeBeatGraph");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processOSCMsg(OSCMessage msg) {
        if (msg != null) {
            DbgTools.print("Received OSC msg " + msg.getName());
        }
        if (msg == null || msg.getName().equals("/startBeatGraph")) {
            long startMs = msg != null ? MusicTools.beats2ms(Float.parseFloat(msg.getArg(0).toString())) : 1L;
            DbgTools.print("Starting beat timing in: " + startMs);
            BeatTimingBehavior beatTiming = new BeatTimingBehavior((BeatGraphLine)this._currGraphLine, startMs);
            ((BeatGraphLine)this._currGraphLine).setBeatTiming(beatTiming);
            beatTiming.setSchedulingBounds(SceneCore.getSceneBounds());
            this._currGraphLine.getBG().addChild((Node)Common3DTools.wrapInBG((Node)beatTiming));
        } else if (msg.getName().equals("/resumeBeatGraph")) {
            int beatGraphId = Integer.parseInt(msg.getArg(0).toString());
            long resumeMs = MusicTools.beats2ms(Float.parseFloat(msg.getArg(1).toString()));
            DbgTools.print("Resuming beat timing of beatgraph# " + beatGraphId + " in: " + resumeMs);
            ((BeatGraphLine)this._coreCtrl.getCurrLayer().getGraph(beatGraphId).getGraphLine()).getBeatTiming().resumeIn(resumeMs);
        }
        Object object = this._notify;
        synchronized (object) {
            this._notify.notifyAll();
        }
    }

    public AbstractGraphLine getCurrGraphLine() {
        return this._currGraphLine;
    }

    public int getCurrGraphId() {
        return this._currentGraphId;
    }

    public SceneCoreOSC getCoreCtrl() {
        return this._coreCtrl;
    }

    public void resetCurrValues() {
        this._state = 0;
        this._currentGraphId = -1;
        this._currGraphLine = null;
    }

    public Object getNotifyObj() {
        return this._notify;
    }

    public void setCurrInstrument(Instrument instrument) {
        this._currInstrument = instrument;
    }

    public Instrument getCurrInstrument() {
        return this._currInstrument;
    }

    public MouseEvent getMouseEvent() {
        return this.mevent;
    }

    public AbstractGraph getCurrGraph() {
        if (this._currGraphLine == null) {
            return null;
        }
        return this._currGraphLine.getGraph();
    }

    public void pauseBeatGraph(BeatGraph beatGraph) {
        ((BeatGraphLine)beatGraph.getGraphLine()).getBeatTiming().reinit();
        DbgTools.print("Sending pause");
        this._coreCtrl.getSCLang().sendOSCData("/change", new String("pause;" + beatGraph.getId()));
        ((BeatGraphLine)beatGraph.getGraphLine()).getBeatTiming().setEnable(false);
    }

    public void resumeBeatGraph(BeatGraph beatGraph) {
        DbgTools.print("Sending resume");
        this._coreCtrl.getSCLang().sendOSCData("/change", new String("resume;" + beatGraph.getId()));
    }

    public void changeToLayerType(int newType, Instrument instr) {
        if (newType == 0) {
            this._layerPickingCtrl = this._seqLayerPickingCtrl;
            this._linePickingCtrl = this._seqLinePickingCtrl;
            this._synthObjPickingCtrl = this._beatPickingCtrl;
        } else {
            this._layerPickingCtrl = this._synthLayerPickingCtrl;
            this._linePickingCtrl = this._synthLinePickingCtrl;
            this._synthObjPickingCtrl = this._synthPickingCtrl;
        }
        this._layerPickingCtrl.instrumentSelect(instr == null ? 0 : instr.getKey() - 1);
    }

    public void setCurrGraphId(int id) {
        this._currentGraphId = id;
    }
}

