/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.ViewingPlatform;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.mkonrad.synes.gui.SceneCore;

public class GuiCtrl {
    private SceneCore _sceneCore;
    private ViewingPlatform _view;
    private OrbitBehavior _orbit;
    private static final float USER_Z_DISTANCE = 12.5f;

    public GuiCtrl(SceneCore sceneCore) {
        this._sceneCore = sceneCore;
        this._view = this._sceneCore.getViewingPlatform();
        this.initOrbitControls();
        this._orbit.setEnable(false);
        this.updateUserPosition();
    }

    public OrbitBehavior getOrbitControl() {
        return this._orbit;
    }

    private void initOrbitControls() {
        this._orbit = new OrbitBehavior((Canvas3D)this._sceneCore.getCanvas3D(), 112);
        this._orbit.setSchedulingBounds(SceneCore.getSceneBounds());
        this._view.setViewPlatformBehavior((ViewPlatformBehavior)this._orbit);
    }

    private void setNewUserPosition(Point3d pos, Point3d lookAt) {
        TransformGroup steerTG = this._view.getViewPlatformTransform();
        Transform3D t3d = new Transform3D();
        steerTG.getTransform(t3d);
        t3d.lookAt(pos, lookAt, new Vector3d(0.0, 1.0, 0.0));
        t3d.invert();
        steerTG.setTransform(t3d);
    }

    public void comeUp() {
        int newLayerLevel = this._sceneCore.getLayerSet().getLayerNum() < this._sceneCore.getCurrLayer().getId() + 2 ? this._sceneCore.createNewLayer(1, true, true).getId() : this._sceneCore.getCurrLayer().getId() + 1;
        this.changeToLayerLevel(newLayerLevel);
    }

    private void changeToLayerLevel(int newLayerLevel) {
        if (this._sceneCore.isOrbitMode()) {
            this._sceneCore.changeOrbitMode();
        }
        this._sceneCore.changeLayer(newLayerLevel, null);
        this._sceneCore.getHUD().updateLayerInfo();
        this._sceneCore.getHUD().updateAvailableInstr();
        this.updateUserPosition();
    }

    public void dive() {
        int level = this._sceneCore.getCurrLayer().getId();
        if (level > 0) {
            this.changeToLayerLevel(level - 1);
        }
    }

    private void updateUserPosition() {
        this.setNewUserPosition(new Point3d(0.0, 0.0, (double)(12.5f + this._sceneCore.getCurrLevelHeight())), new Point3d(0.0, 0.0, (double)this._sceneCore.getCurrLevelHeight()));
    }
}

