/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractLayerPickingCtrl;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.BeatGraph;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.gui.elements.BeatGraphLine;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class SeqLayerPickingCtrl
extends AbstractLayerPickingCtrl {
    public SeqLayerPickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
    }

    protected void changeBeatDur(int byValue) {
        Beat currBeat = ((BeatGraph)this._pickCtrl.getCurrGraphLine().getGraph()).getBeat(this._pickCtrl.getCurrGraphLine().getGraph().size() - 1);
        float newDur = currBeat.getDur() + (float)byValue * 0.0625f;
        if (newDur <= 0.0f) {
            return;
        }
        currBeat.setDur(newDur);
        this._pickCtrl.getCurrGraphLine().movedPointer(null);
    }

    @Override
    public boolean moved(Node pickedObj, Point3f intercept, int mouseState) {
        if (this._pickCtrl.getCurrGraphLine() != null) {
            this._pickCtrl.getCurrGraphLine().movedPointer(intercept);
        }
        return true;
    }

    @Override
    protected void createNewGraph(Point3f intercept) {
        DbgTools.print("Creating new BeatGraph");
        this._pickCtrl.setState(1);
        Beat newBeat = this.createNewBeat(intercept);
        Beat pointerBeat = this.createNewBeat(intercept);
        BeatGraph beatGraph = new BeatGraph();
        this._pickCtrl.setCurrGraphId(beatGraph.getId());
        beatGraph.add(newBeat);
        newBeat.setGraph(beatGraph);
        BeatGraphLine graphLine = this._pickCtrl.createGraphLine(beatGraph);
        this._coreCtrl.getCurrLayer().addGraph(beatGraph);
        beatGraph.setLayerLevel(this._coreCtrl.getLayerSet().getCurrLayerLevel());
        this.startMouseOver(graphLine, pointerBeat, intercept);
        this._pickCtrl.addNewGraphElementsToScene((Node)newBeat.getInstrumentShape().getBG());
    }

    @Override
    protected void addObjectToGraph(Point3f intercept) {
        DbgTools.print("Adding beat to BeatGraph");
        Beat newBeat = this.createNewBeat(intercept);
        this.connectBeats(newBeat);
        this._pickCtrl.getCurrGraphLine().clicked(newBeat);
        this._pickCtrl.addNewGraphElementsToScene((Node)newBeat.getInstrumentShape().getBG());
    }

    protected Beat createNewBeat(Point3f intercept) {
        Instrument currInstr = this._pickCtrl.getCurrInstrument();
        float lastDur = 1.0f;
        if (this._pickCtrl.getCurrGraph() != null) {
            lastDur = ((Beat)this._pickCtrl.getCurrGraph().getLast()).getDur();
        }
        Beat newBeat = new Beat(currInstr, lastDur, 0.1f, 1.0f);
        newBeat.setInstrumentShape(currInstr.createInstrumentShape(newBeat, intercept));
        DbgTools.print("Created new beat#" + newBeat.getId());
        return newBeat;
    }

    protected void connectBeats(Beat newBeat) {
        BeatGraph beatGraph = (BeatGraph)this._pickCtrl.getCurrGraph();
        beatGraph.add(newBeat);
        newBeat.setGraph(beatGraph);
        Beat prevBeat = beatGraph.getBeat(beatGraph.size() - 2);
        newBeat.setPrevBeat(prevBeat);
        prevBeat.setNextBeat(newBeat);
    }

    @Override
    public void cancelGraphCreation() {
        AbstractGraphLine graphLine = this._pickCtrl.getCurrGraphLine();
        if (graphLine == null) {
            return;
        }
        if (graphLine.getGraph().size() <= 1) {
            DbgTools.print("Canceling BeatGraph construction");
            graphLine.canceled();
            this._pickCtrl.getCurrGraphLine().getBG().detach();
            this._coreCtrl.getCurrLayer().removeGraph(this._pickCtrl.getCurrGraphId());
            this.stopMouseOver(null);
        } else {
            graphLine.canceled();
            this.finishGraph(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishGraph(Point3f intercept) {
        DbgTools.print("Finishing BeatGraph");
        BeatGraph beatGraph = (BeatGraph)this._pickCtrl.getCurrGraphLine().getGraph();
        if (beatGraph.getState() == 0) {
            beatGraph.getBeat(beatGraph.size() - 1).setDur(beatGraph.getBeat(beatGraph.size() - 2).getDur());
        }
        if (this._coreCtrl.isOSCMode()) {
            DbgTools.print("Sending OSC data");
            this._coreCtrl.getSCLang().sendOSCDataOneByOne("/change", beatGraph.generateOSCData(this._coreCtrl.getCurrLayer().getSCGroup().getNodeID()));
        } else {
            this._pickCtrl.processOSCMsg(null);
        }
        try {
            Object object = this._pickCtrl.getNotifyObj();
            synchronized (object) {
                this._pickCtrl.getNotifyObj().wait(500L);
            }
        }
        catch (InterruptedException e) {
            ErrTools.print(e);
        }
        this.stopMouseOver(intercept);
    }
}

