/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.io.IOException;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractLayerPickingCtrl;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.gui.elements.SynthGraphLine;
import net.mkonrad.synes.synth.SynthExt;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class SynthLayerPickingCtrl
extends AbstractLayerPickingCtrl {
    public SynthLayerPickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
    }

    @Override
    public boolean moved(Node pickedObj, Point3f intercept, int mouseState) {
        if (this._pickCtrl.getCurrGraphLine() != null) {
            this._pickCtrl.getCurrGraphLine().movedPointer(intercept);
            if (this._coreCtrl.isOSCMode() && this._coreCtrl.getCurrLayer().getType() == 1 && this._pickCtrl.getCurrGraph() != null) {
                this.updatePlayingGraph((SynthGraph)this._pickCtrl.getCurrGraph());
            }
        }
        return true;
    }

    private void updatePlayingGraph(SynthGraph graph) {
        SynthObj synthObj = null;
        Modulator mod = graph.getModulator();
        boolean modInHand = false;
        if (mod == null) {
            mod = (Modulator)graph.getGraphLine().getPointerObj();
            synthObj = graph.getSynthObj(0);
            modInHand = true;
        } else {
            synthObj = graph.getGraphLine().getPointerObj();
        }
        SynthExt synth = synthObj.getSynth();
        try {
            if (synthObj != mod && synth != null) {
                synth.modSynthSynth(mod);
            }
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
    }

    @Override
    protected void createNewGraph(Point3f intercept) {
        DbgTools.print("Creating new SynthGraph");
        this._pickCtrl.setState(1);
        SynthObj newSynthObj = this.createNewSynthObj(intercept);
        Modulator newMod = new Modulator(0.1f, new Point3f(intercept.x + 0.001f, intercept.y, intercept.z));
        SynthGraph synthGraph = new SynthGraph();
        this._pickCtrl.setCurrGraphId(synthGraph.getId());
        synthGraph.setLayerLevel(this._coreCtrl.getLayerSet().getCurrLayerLevel());
        synthGraph.addSynthObj(newSynthObj);
        newSynthObj.setGraph(synthGraph);
        SynthGraphLine graphLine = this._pickCtrl.createGraphLine(synthGraph);
        this._coreCtrl.getCurrLayer().addGraph(synthGraph);
        if (this._coreCtrl.isOSCMode() && this._pickCtrl.getMouseEvent().isControlDown()) {
            synthGraph.setState(10);
            this.playSynth(newSynthObj);
        } else {
            synthGraph.setState(11);
        }
        this.startMouseOver(graphLine, newMod, intercept);
        this._pickCtrl.addNewGraphElementsToScene((Node)newSynthObj.getInstrumentShape().getBG());
    }

    protected SynthObj createNewSynthObj(Point3f intercept) {
        Instrument currInstr = this._pickCtrl.getCurrInstrument();
        SynthObj newSynthObj = new SynthObj(currInstr, 0.1f);
        newSynthObj.setInstrumentShape(currInstr.createInstrumentShape(newSynthObj, intercept));
        DbgTools.print("Created new synth obj#" + newSynthObj.getId());
        return newSynthObj;
    }

    @Override
    protected void addObjectToGraph(Point3f intercept) {
        SynthGraph synthGraph = (SynthGraph)this._pickCtrl.getCurrGraph();
        if (synthGraph.getModulator() != null) {
            DbgTools.print("Adding synth to SynthGraph");
            SynthObj newSynth = this._pickCtrl.getCurrGraphLine().getPointerObj();
            synthGraph.addSynthObj(newSynth);
            newSynth.setGraph(synthGraph);
            this._pickCtrl.getCurrGraphLine().clicked(newSynth);
            newSynth.getInstrumentShape().getPrimitive().setPickable(true);
            newSynth.getInstrumentShape().getBG().detach();
            this._pickCtrl.addNewGraphElementsToScene((Node)newSynth.getInstrumentShape().getBG());
        } else {
            DbgTools.print("Adding modulator to SynthGraph");
            Modulator mod = (Modulator)this._pickCtrl.getCurrGraphLine().getPointerObj();
            synthGraph.addModulator(mod);
            mod.setGraph(synthGraph);
            this._pickCtrl.getCurrGraphLine().clicked(mod);
            mod.getInstrumentShape().getPrimitive().setPickable(true);
            mod.getInstrumentShape().getBG().detach();
            this._pickCtrl.addNewGraphElementsToScene((Node)mod.getInstrumentShape().getBG());
        }
        SynthObj newPointerObj = this.createNewSynthObj(intercept);
        if (this._coreCtrl.isOSCMode() && synthGraph.getState() == 10) {
            this.playSynth(newPointerObj);
        }
        this._pickCtrl.getCurrGraphLine().changePointerObj(newPointerObj);
    }

    @Override
    public void cancelGraphCreation() {
        AbstractGraphLine graphLine = this._pickCtrl.getCurrGraphLine();
        if (graphLine == null) {
            return;
        }
        if (this._pickCtrl.getCurrGraph().size() <= 1) {
            DbgTools.print("Canceling SynthGraph construction");
            if (this._coreCtrl.isOSCMode()) {
                try {
                    if (((SynthGraph)this._pickCtrl.getCurrGraph()).getSynthObj(0).getSynth() != null) {
                        ((SynthGraph)this._pickCtrl.getCurrGraph()).getSynthObj(0).getSynth().release();
                    }
                }
                catch (IOException e) {
                    ErrTools.print(e);
                }
            }
            graphLine.canceled();
            this._pickCtrl.getCurrGraphLine().getBG().detach();
            this._coreCtrl.getCurrLayer().removeGraph(this._pickCtrl.getCurrGraphId());
            this.stopMouseOver(null);
        } else {
            this.cleanUp();
            graphLine.canceled();
            this.finishGraph(null);
        }
    }

    @Override
    protected void cleanUp() {
        if (this._coreCtrl.isOSCMode()) {
            try {
                if (this._pickCtrl.getCurrGraphLine().getPointerObj().getSynth() != null) {
                    this._pickCtrl.getCurrGraphLine().getPointerObj().getSynth().release();
                }
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
        }
    }

    @Override
    protected void finishGraph(Point3f intercept) {
        DbgTools.print("Finishing SynthGraph");
        this.stopMouseOver(intercept);
    }

    public void changeSynthObjInstr(SynthObj synthObj) {
        if (this._coreCtrl.isOSCMode() && synthObj.getSynth() != null) {
            try {
                synthObj.getSynth().release();
                synthObj.setSynth(null);
                this.playSynth(synthObj);
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
        }
    }
}

