/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.io.IOException;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.ctrl.AbstractLinePickingCtrl;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.util.ErrTools;

public class SynthLinePickingCtrl
extends AbstractLinePickingCtrl {
    public SynthLinePickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
    }

    @Override
    public void removeGraph() {
        if (this._selectedGraphLine == null) {
            return;
        }
        if (this._coreCtrl.isOSCMode()) {
            SynthGraph graph = (SynthGraph)this._selectedGraphLine.getGraph();
            try {
                int i = 0;
                while (i < graph.size()) {
                    SynthObj synthObj = graph.getSynthObj(i);
                    if (synthObj.getSynth() != null) {
                        synthObj.getSynth().release();
                        synthObj.setSynth(null);
                    }
                    ++i;
                }
                graph.clear();
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
        }
        this._selectedGraphLine.getBG().detach();
        this._coreCtrl.getCurrLayer().removeGraph(this._selectedGraphLine.getGraph().getId());
        this.clearSelection();
    }

    @Override
    public boolean clicked(Node pickedObj, Point3f where, int mouseState) {
        if (this._pickCtrl.getState() == 1) {
            return false;
        }
        this.makeSelection((AbstractGraphLine)pickedObj, where);
        if (((SynthGraph)this._selectedGraphLine.getGraph()).getState() == 11 && this._pickCtrl.getMouseEvent().isControlDown()) {
            this.playSynthGraph((SynthGraph)this._selectedGraphLine.getGraph());
        }
        return true;
    }

    @Override
    public boolean dragged(Point3f where, int mouseState) {
        if (this._selectedGraphLine == null) {
            return true;
        }
        SynthGraph graph = (SynthGraph)this._selectedGraphLine.getGraph();
        try {
            int i = 0;
            while (i < graph.size()) {
                if (graph.getSynthObj(i).getSynth() != null) {
                    graph.getSynthObj(i).getSynth().modSynthSynth(graph.getModulator());
                }
                ++i;
            }
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
        this.moveGraphLine(new Vector3f((Tuple3f)where));
        return true;
    }

    @Override
    public boolean released(Point3f where, int mouseState) {
        if (((SynthGraph)this._selectedGraphLine.getGraph()).getState() == 11) {
            this.releaseSynthGraph((SynthGraph)this._selectedGraphLine.getGraph());
        }
        this.clearSelection();
        return true;
    }
}

