/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.ctrl;

import java.io.IOException;
import javax.media.j3d.Node;
import javax.vecmath.Point3f;
import net.mkonrad.synes.ctrl.AbstractPickableObj;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.data.AbstractGraph;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.util.ErrTools;

public class SynthObjPickingCtrl
extends AbstractPickableObj {
    private Modulator _selectedModulator = null;

    public SynthObjPickingCtrl(CentralPickingCtrl pickCtrl) {
        super(pickCtrl);
    }

    @Override
    public boolean clicked(Node pickedObj, Point3f intercept, int mouseState) {
        if (this._pickCtrl.getState() == 1 && this._pickCtrl.getCurrGraph().size() > 1) {
            this._pickCtrl.getLayerPickingCtrl().cleanUp();
            this._pickCtrl.getCurrGraphLine().cleanUpTail();
            this._pickCtrl.getLayerPickingCtrl().finishGraph(intercept);
        } else if (this._pickCtrl.getState() == 0) {
            this._selectedModulator = null;
            this._selectedSynthObj = null;
            this._selectedGraphLine = null;
            try {
                this._selectedModulator = (Modulator)pickedObj.getUserData();
                this._selectedSynthObj = this._selectedModulator;
                this._selectedGraphLine = this._selectedModulator.getGraph().getGraphLine();
            }
            catch (ClassCastException e) {
                this._selectedSynthObj = (SynthObj)pickedObj.getUserData();
                this._selectedGraphLine = this._selectedSynthObj.getGraph().getGraphLine();
            }
            SynthGraph synthGraph = (SynthGraph)this._selectedGraphLine.getGraph();
            if (synthGraph.getState() == 11 && this._pickCtrl.getMouseEvent().isControlDown()) {
                if (this._selectedModulator != null) {
                    this.playSynthGraph(synthGraph);
                } else {
                    this.playSynth(this._selectedSynthObj);
                }
            }
            this.startEditMode();
        }
        return true;
    }

    @Override
    public boolean dragged(Point3f intercept, int mouseState) {
        SynthObj synthObj = null;
        if (this._selectedModulator != null) {
            synthObj = this._selectedModulator;
        } else if (this._selectedSynthObj != null) {
            synthObj = this._selectedSynthObj;
        }
        if (synthObj != null) {
            synthObj.getInstrumentShape().setPos(intercept);
            SynthObj[] synthsToModify = null;
            Modulator mod = null;
            if (this._selectedModulator != null) {
                mod = this._selectedModulator;
                AbstractGraph graph = this._selectedGraphLine.getGraph();
                synthsToModify = new SynthObj[graph.size() - 1];
                int synthI = 0;
                int i = 0;
                while (i < graph.size()) {
                    if (graph.get(i) != mod) {
                        synthsToModify[synthI] = (SynthObj)graph.get(i);
                        ++synthI;
                    }
                    ++i;
                }
            } else {
                synthsToModify = new SynthObj[]{synthObj};
                mod = ((SynthGraph)this._selectedGraphLine.getGraph()).getModulator();
            }
            if (this._coreCtrl.isOSCMode()) {
                try {
                    int i = 0;
                    while (i < synthsToModify.length) {
                        if (synthsToModify[i].getSynth() != null) {
                            synthsToModify[i].getSynth().modSynthSynth(mod);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    ErrTools.print(e);
                }
            }
            this._selectedGraphLine.movedObj(synthObj);
        }
        return true;
    }

    @Override
    public boolean moved(Node pickedObj, Point3f where, int mouseState) {
        return false;
    }

    @Override
    public boolean released(Point3f intercept, int mouseState) {
        this._selectedGraphLine.releaseMove(intercept);
        SynthGraph synthGraph = (SynthGraph)this._selectedGraphLine.getGraph();
        if (synthGraph.getState() == 11) {
            this.releaseSynthGraph(synthGraph);
        }
        this._selectedModulator = null;
        this._selectedSynthObj = null;
        this._selectedGraphLine = null;
        this.stopEditMode();
        return true;
    }
}

