/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.SeqInstrument;
import net.mkonrad.synes.data.SynthObj;

public class Beat
extends SynthObj
implements Cloneable {
    private float _sustain;
    private float _dur;
    private Beat _prevBeat = null;
    private Beat _nextBeat = null;

    public Beat(Instrument instrument, float dur, float amp, float sustain) {
        super(instrument, amp);
        this._dur = dur;
        this._sustain = sustain;
    }

    public Beat getPrevBeat() {
        return this._prevBeat;
    }

    public void setPrevBeat(Beat prevBeat) {
        this._prevBeat = prevBeat;
    }

    public Beat getNextBeat() {
        return this._nextBeat;
    }

    public void setNextBeat(Beat nextBeat) {
        this._nextBeat = nextBeat;
    }

    public float getDur() {
        return this._dur;
    }

    public void setDur(float dur) {
        this._dur = dur;
    }

    public float getSustain() {
        return this._sustain;
    }

    public void setSustain(float sustain) {
        this._sustain = sustain;
    }

    public String constructOSCMsgPart() {
        return this.constructOSCMsgPart(this._dur);
    }

    public String constructOSCMsgPart(float customDur) {
        float oldDur = this._dur;
        this._dur = customDur;
        Object[] extraSeqValues = ((SeqInstrument)this.getInstrument()).getExtraSeqValues(this);
        float[] values = ((SeqInstrument)this.getInstrument()).getAllSynthValues(this);
        this._dur = oldDur;
        String msg = "";
        int i = 0;
        while (i < extraSeqValues.length) {
            msg = String.valueOf(msg) + extraSeqValues[i] + ",";
            ++i;
        }
        i = 0;
        while (i < values.length) {
            msg = String.valueOf(msg) + values[i];
            if (i < values.length - 1) {
                msg = String.valueOf(msg) + ",";
            }
            ++i;
        }
        this._dur = oldDur;
        return msg;
    }

    public Object[] generateOSCUpdate() {
        String msgHeader = "updateBeat;" + this._graph.getId() + ";0;";
        Object[] data = this._graph.getState() == 0 ? new Object[2] : new Object[]{String.valueOf(msgHeader) + this._graph.indexOf(this) + ";" + this.constructOSCMsgPart()};
        if (this._graph.getState() == 0 && this._prevBeat != null && this._nextBeat != null) {
            int lastI = this._graph.size() - 1;
            data[1] = String.valueOf(msgHeader) + (2 * lastI - this._graph.indexOf(this)) + ";" + this.constructOSCMsgPart(this._prevBeat.getDur());
        }
        return data;
    }
}

