/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class Config
extends Properties {
    private static String CONFIG_RES = "./config/config.properties";
    private static String DEFAULTS_RES = "./config/config.defaults";
    private Properties _defaults = null;

    public Config() {
        this.loadDefaults();
        this.loadProperties();
    }

    public String getCfgValue(String key) {
        String defValue = this._defaults.getProperty(key);
        if (defValue == null) {
            ErrTools.die("Invalid property: " + key);
        }
        return this.getProperty(key, defValue).toLowerCase();
    }

    private void loadProperties() {
        this.loadAsResource(CONFIG_RES, this);
    }

    private void loadDefaults() {
        this._defaults = new Properties();
        this.loadAsResource(DEFAULTS_RES, this._defaults);
    }

    private void loadAsResource(String res, Properties toObj) {
        try {
            toObj.load(new FileReader(res));
            DbgTools.print("Loaded properties from " + res);
        }
        catch (IOException e) {
            ErrTools.die("Error loading properties from " + res);
        }
    }
}

