/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.vecmath.Color3f;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.SeqInstrument;
import net.mkonrad.synes.data.SynthInstrument;
import net.mkonrad.synes.gui.style.Colors;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;
import sun.misc.Launcher;

public class InstrumentCabinet {
    private ArrayList<Instrument> _seqInstrList = new ArrayList();
    private ArrayList<Instrument> _synthInstrList = new ArrayList();

    public InstrumentCabinet() {
        this.loadInstruments("net.mkonrad.synes.data.instruments");
    }

    private void loadInstruments(String pckgname) {
        URL url;
        File directory;
        Color3f[] colors = new Color3f[]{Colors.red, Colors.brightBlue, Colors.green};
        String name = new String(pckgname);
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = (url = Launcher.class.getResource(name = name.replace('.', '/'))).getProtocol().equals("jar") ? new File("./plugins" + name) : new File(url.getFile())).exists()) {
            DbgTools.print("Loading Instruments from " + directory);
            int colIndex = 0;
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        Object o = Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        if (o instanceof Instrument) {
                            Instrument currInstr = (Instrument)o;
                            if (currInstr instanceof SeqInstrument) {
                                currInstr.setKey(this._seqInstrList.size() + 1);
                                this._seqInstrList.add(currInstr);
                                DbgTools.print("Added SeqInstrument " + currInstr.getName());
                            }
                            if (currInstr instanceof SynthInstrument) {
                                currInstr.setKey(this._synthInstrList.size() + 1);
                                this._synthInstrList.add(currInstr);
                                DbgTools.print("Added SynthInstrument " + currInstr.getName());
                            }
                            ++colIndex;
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        ErrTools.print(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        } else {
            ErrTools.die("Failed loading Instruments from " + directory);
        }
    }

    public ArrayList<Instrument> get(int type) {
        if (type == 0) {
            return this._seqInstrList;
        }
        return this._synthInstrList;
    }

    public Instrument get(int type, int index) {
        if (type == 0) {
            return this._seqInstrList.get(index);
        }
        return this._synthInstrList.get(index);
    }
}

