/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import de.sciss.jcollider.Group;
import java.util.Collection;
import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.data.AbstractGraph;

public class Layer {
    public static final int TYPE_SEQUENCER = 0;
    public static final int TYPE_SYNTH = 1;
    private int _id;
    private HashMap<Integer, AbstractGraph> _graphs;
    private TransformGroup _layerTG;
    private BranchGroup _layerBG;
    private int _type = 0;
    private Group _scGroup = null;

    public Layer(int id, int type) {
        this._id = id;
        this._type = type;
        this._graphs = new HashMap();
        this._layerTG = new TransformGroup();
        this._layerTG.setCapability(14);
        this._layerTG.setCapability(13);
        this._layerTG.setCapability(6);
        this._layerBG = new BranchGroup();
        this._layerBG.setCapability(17);
        this._layerBG.setCapability(14);
        this._layerBG.setCapability(13);
        this._layerBG.setCapability(6);
        this._layerBG.addChild((Node)this._layerTG);
    }

    public int getId() {
        return this._id;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void addGraph(AbstractGraph b) {
        this._graphs.put(new Integer(b.getId()), b);
    }

    public void removeGraph(int id) {
        this._graphs.remove(id);
    }

    public Collection<AbstractGraph> getGraphs() {
        return this._graphs.values();
    }

    public AbstractGraph getGraph(int id) {
        return this._graphs.get(id);
    }

    public TransformGroup getLayerTG() {
        return this._layerTG;
    }

    public BranchGroup getLayerBG() {
        return this._layerBG;
    }

    public void setSCGroup(Group g) {
        this._scGroup = g;
    }

    public Group getSCGroup() {
        return this._scGroup;
    }

    public void setHeight(float h) {
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3f(0.0f, 0.0f, h));
        this._layerTG.setTransform(t3d);
    }
}

