/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import java.util.ArrayList;
import java.util.Collection;
import net.mkonrad.synes.data.AbstractGraph;
import net.mkonrad.synes.data.Layer;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.elements.instruments.InstrumentShape;

public class LayerSet {
    private ArrayList<Layer> _layers = new ArrayList();
    private int _currLayerLevel = 0;

    public void setCurrLayerLevel(int l) {
        this._currLayerLevel = l;
    }

    public int getCurrLayerLevel() {
        return this._currLayerLevel;
    }

    public void addLayer(Layer l) {
        this._layers.add(l);
    }

    public void removeLayer(int index) {
        this._layers.remove(index);
    }

    public Layer getLayer(int index) {
        return this._layers.get(index);
    }

    public Layer[] getLayers() {
        return this._layers.toArray(new Layer[0]);
    }

    public Layer getCurrLayer() {
        return this.getLayer(this._currLayerLevel);
    }

    public int getLayerNum() {
        return this._layers.size();
    }

    public void setEnabled(int layer, boolean enabled) {
        if (layer < 0) {
            layer = this._currLayerLevel;
        }
        Collection<AbstractGraph> graphs = this.getLayer(layer).getGraphs();
        for (AbstractGraph graph : graphs) {
            int iSynth = 0;
            while (iSynth < graph.size()) {
                InstrumentShape instrShape = ((SynthObj)graph.get(iSynth)).getInstrumentShape();
                instrShape.setEnabled(enabled);
                ++iSynth;
            }
            graph.getGraphLine().setEnabled(enabled);
        }
    }
}

