/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import java.util.Locale;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.data.AbstractInstrument;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.util.MusicTools;

public abstract class SeqInstrument
extends AbstractInstrument {
    protected String[] _extraSeqArgs = new String[]{"dur", "instrument"};

    public SeqInstrument() {
        this._synthArgs = new String[]{"amp", "sustain", "pitch", "pan"};
        this._modArgs = new String[]{"pan", "pitch"};
    }

    public String[] getExtraSeqArgs() {
        return this._extraSeqArgs;
    }

    public Object[] getExtraSeqValues(Beat beat) {
        return new Object[]{String.format(Locale.US, "%1$.2f", Float.valueOf(beat.getDur())), this._name};
    }

    public float[] getAllModValues(Point3f pos) {
        float[] values = new float[this._modArgs.length];
        int i = 0;
        while (i < this._modArgs.length) {
            values[i] = this.getModValueForArg(this._modArgs[i], pos);
            ++i;
        }
        return values;
    }

    @Override
    public float getValueForArg(String argName, SynthObj synthData) {
        Beat beat = (Beat)synthData;
        if (argName.equals("pan")) {
            return this.getPanArg(beat.getInstrumentShape().getAbsPos());
        }
        if (argName.equals("pitch")) {
            return this.getPitchArg(beat.getInstrumentShape().getAbsPos());
        }
        if (argName.equals("sustain")) {
            return beat.getSustain();
        }
        if (argName.equals("amp")) {
            return beat.getAmp();
        }
        return 0.0f;
    }

    public float getModValueForArg(String argName, Point3f pos) {
        if (argName.equals("pan")) {
            return this.getPanArg(new Vector3f((Tuple3f)pos));
        }
        if (argName.equals("pitch")) {
            return this.getPitchArg(new Vector3f((Tuple3f)pos));
        }
        return 0.0f;
    }

    protected float getPanArg(Vector3f pos) {
        return MusicTools.getPanFromXCoord(pos.x);
    }

    protected abstract float getPitchArg(Vector3f var1);
}

