/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.mkonrad.synes.data.AbstractInstrument;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.util.Common3DTools;
import net.mkonrad.synes.util.MusicTools;

public abstract class SynthInstrument
extends AbstractInstrument {
    protected String[] _modArgs;

    public SynthInstrument() {
        this._synthArgs = new String[]{"x", "y", "amp"};
        this._modArgs = new String[]{"x", "y", "amp", "modDist", "modAmp"};
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public String[] getModArgs() {
        return this._modArgs;
    }

    @Override
    public float getValueForArg(String argName, SynthObj synthData) {
        if (argName.equals("x")) {
            return this.getXArg(synthData);
        }
        if (argName.equals("y")) {
            return this.getYArg(synthData);
        }
        if (argName.equals("amp")) {
            return synthData.getAmp();
        }
        return 0.0f;
    }

    public float[] getAllModValues(SynthObj synth, Modulator mod) {
        float[] values = new float[this._modArgs.length];
        int i = 0;
        while (i < this._modArgs.length) {
            values[i] = this.getModValueForArg(this._modArgs[i], synth, mod);
            ++i;
        }
        return values;
    }

    public float getModValueForArg(String argName, SynthObj synth, Modulator mod) {
        if (argName.equals("modDist")) {
            return synth.getDistance();
        }
        if (argName.equals("modAmp")) {
            return mod.getAmp();
        }
        return this.getValueForArg(argName, synth);
    }

    protected float getModDistArg(SynthObj synth, Modulator mod) {
        return Common3DTools.distance2D(new Point3f((Tuple3f)synth.getInstrumentShape().getAbsPos()), new Point3f((Tuple3f)mod.getInstrumentShape().getAbsPos()));
    }

    protected float getXArg(SynthObj synth) {
        return MusicTools.getPanFromXCoord(synth.getInstrumentShape().getAbsPos().x);
    }

    protected float getYArg(SynthObj synth) {
        return MusicTools.getMidiFromYCoord(synth.getInstrumentShape().getAbsPos().y, false);
    }
}

