/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.data.instruments;

import javax.vecmath.Point3f;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthInstrument;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.elements.instruments.InstrumentShape;
import net.mkonrad.synes.gui.elements.instruments.TriangleShape;
import net.mkonrad.synes.gui.style.Colors;
import net.mkonrad.synes.util.MusicTools;

public class Scratch
extends SynthInstrument {
    public Scratch() {
        this._name = "synes_scratch";
        this._iconName = "scratch.png";
        this._texture = "triangle.png";
        this._color = Colors.turquoise;
        this._synthArgs = new String[]{"x", "y", "amp"};
        this._modArgs = new String[]{"x", "y", "amp", "modX", "modY", "modAmp"};
    }

    @Override
    public boolean needsKeyboard() {
        return false;
    }

    @Override
    public InstrumentShape createInstrumentShape(SynthObj synthData, Point3f pos) {
        return new TriangleShape(synthData, pos);
    }

    @Override
    public float getModValueForArg(String argName, SynthObj synth, Modulator mod) {
        if (argName.equals("modX")) {
            return (MusicTools.getPanFromXCoord(mod.getAbsPos().x) + 1.0f) / 2.0f;
        }
        if (argName.equals("modY")) {
            return (MusicTools.getPitchFromYCoord(mod.getAbsPos().y) + 1.0f) / 2.0f;
        }
        if (argName.equals("modAmp")) {
            return mod.getAmp();
        }
        return this.getValueForArg(argName, synth);
    }

    @Override
    protected float getYArg(SynthObj synth) {
        return MusicTools.getPitchFromYCoord(synth.getInstrumentShape().getAbsPos().y);
    }
}

