/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3DGraphics2D;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class Canvas3DExt
extends Canvas3D {
    private ArrayList<BufferedImage> _instrImgs = new ArrayList();
    private ArrayList<int[]> _instrImgPos = new ArrayList();
    private BufferedImage _overlayImg;
    private Graphics2D _overlayG2D;
    private J3DGraphics2D _overlayRenderer;
    private int _panelWidth;
    private int _panelHeight;

    public Canvas3DExt(GraphicsConfiguration gconf, int panelWidth, int panelHeight) {
        super(gconf);
        this._panelWidth = panelWidth;
        this._panelHeight = panelHeight;
        this._overlayImg = new BufferedImage(panelWidth, panelHeight, 6);
        this._overlayG2D = this._overlayImg.createGraphics();
        this._overlayRenderer = this.getGraphics2D();
    }

    public void postRender() {
        this.clearSurface();
        this.drawInstrIcons();
        this._overlayRenderer.drawAndFlushImage(this._overlayImg, 0, 0, (ImageObserver)((Object)this));
    }

    private void drawInstrIcons() {
        int i = 0;
        while (i < this._instrImgs.size()) {
            int[] pos = this._instrImgPos.get(i);
            this._overlayG2D.drawImage((Image)this._instrImgs.get(i), pos[0], pos[1], null);
            ++i;
        }
    }

    public void clearInstrImgs() {
        this._instrImgs.clear();
        this._instrImgPos.clear();
    }

    public void addInstrImg(int x, int y, String iconFile) {
        this._instrImgs.add(this.loadImage(iconFile));
        this._instrImgPos.add(new int[]{x, y});
    }

    private BufferedImage loadImage(String fnm) {
        BufferedImage im = null;
        try {
            im = ImageIO.read(new File("./textures/instruments/" + fnm));
            DbgTools.print("Loaded icon " + fnm);
        }
        catch (IOException e) {
            DbgTools.print("Error loading icon " + fnm);
            ErrTools.print(e);
        }
        return im;
    }

    private void clearSurface() {
        this._overlayG2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        this._overlayG2D.fillRect(0, 0, this._panelWidth, this._panelHeight);
        this._overlayG2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this._overlayG2D.setColor(Color.BLACK);
    }
}

