/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import net.mkonrad.synes.data.Config;
import net.mkonrad.synes.gui.SceneCoreOSC;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class Main
extends JFrame
implements WindowListener {
    SceneCoreOSC _core;

    public Main() {
        super("Synesthesia");
        if (!this.hasJ3D()) {
            ErrTools.die("Java3D Libraries not found!");
        }
        DbgTools.setDbgMode(true);
        boolean oscOn = System.getProperty("osc") == null || System.getProperty("osc").equals("true");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this._core = new SceneCoreOSC(this, new Config(), oscOn);
        c.add((Component)this._core, "Center");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setResizable(false);
        this.centerWindow();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new Main();
    }

    private boolean hasJ3D() {
        try {
            Class.forName("com.sun.j3d.utils.universe.SimpleUniverse");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void centerWindow() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winDim = this.getSize();
        this.setLocation((screenDim.width - winDim.width) / 2, (screenDim.height - winDim.height) / 2);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this._core.shutdown();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

