/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui;

import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import de.sciss.jcollider.Group;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.io.IOException;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.ctrl.CentralPickingCtrl;
import net.mkonrad.synes.ctrl.GlobalKeyListener;
import net.mkonrad.synes.ctrl.GuiCtrl;
import net.mkonrad.synes.data.Config;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.InstrumentCabinet;
import net.mkonrad.synes.data.Layer;
import net.mkonrad.synes.data.LayerSet;
import net.mkonrad.synes.gui.Canvas3DExt;
import net.mkonrad.synes.gui.SceneCoreOSC;
import net.mkonrad.synes.gui.elements.GroundShape;
import net.mkonrad.synes.gui.elements.HUDOverlay;
import net.mkonrad.synes.gui.style.Colors;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;

public class SceneCore
extends JComponent {
    public static final int BOUNDSIZE = 100;
    public static final float DEFAULT_BPM = 60.0f;
    public static final float LAYER_HEIGHT = 0.5f;
    public static final int DEFAULT_NUM_OCTAVES = 5;
    protected static boolean OSC_MODE = false;
    private boolean _orbitMode = false;
    private static BoundingSphere _bounds = null;
    private static InstrumentCabinet _instrCabinet = new InstrumentCabinet();
    private static float _bpm = 60.0f;
    private SimpleUniverse _suniverse;
    private BranchGroup _sceneBG;
    private BranchGroup _pickableObjBG;
    private BranchGroup _layersBG;
    private Canvas3DExt _canvas3D;
    protected HUDOverlay _hud;
    private GuiCtrl _guiCtrl;
    private CentralPickingCtrl _pickingCtrl;
    private GroundShape _ground;
    private LayerSet _layerSet;
    private JFrame _parentWindow;
    private Config _conf;

    public SceneCore(JFrame parentWindow, Config conf) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this._conf = conf;
        this._parentWindow = parentWindow;
        int panelWidth = new Integer(this._conf.getCfgValue("width"));
        int panelHeight = new Integer(this._conf.getCfgValue("height"));
        if (this._conf.getCfgValue("fullscreen").equals("true")) {
            this._parentWindow.setUndecorated(true);
            this.setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
            DbgTools.print("Entering fullscreen mode...");
        } else {
            this.setPreferredSize(new Dimension(panelWidth, panelHeight));
        }
        this._canvas3D = new Canvas3DExt(SimpleUniverse.getPreferredConfiguration(), panelWidth, panelHeight);
        this.add("Center", (Component)((Object)this._canvas3D));
        this._canvas3D.setFocusable(true);
        this._canvas3D.requestFocus();
        this._suniverse = new SimpleUniverse((Canvas3D)this._canvas3D);
        DbgTools.print("J3D version: " + VirtualUniverse.getProperties().get("j3d.version"));
        this.createSceneGraph();
        this.createHUD();
        this._suniverse.getViewer().getView().setTransparencySortingPolicy(1);
        this._suniverse.addBranchGraph(this._sceneBG);
    }

    protected void initContents() {
        if (!OSC_MODE) {
            this.showContents();
        } else {
            this._hud.displayLoadingMsg();
        }
    }

    private void createControllers() {
        this.addKeyListener(new GlobalKeyListener(this));
        this._guiCtrl = new GuiCtrl(this);
        this._pickingCtrl = new CentralPickingCtrl(this._pickableObjBG, this);
        this._ground.getBG().addChild((Node)this._pickingCtrl);
    }

    private void createHUD() {
        this._hud = new HUDOverlay(this);
        this._hud.display();
    }

    public boolean isOSCMode() {
        return OSC_MODE;
    }

    public BranchGroup getRootBG() {
        return this._sceneBG;
    }

    public GroundShape getGround() {
        return this._ground;
    }

    public HUDOverlay getHUD() {
        return this._hud;
    }

    public CentralPickingCtrl getPickingCtrl() {
        return this._pickingCtrl;
    }

    public Layer getCurrLayer() {
        return this._layerSet.getCurrLayer();
    }

    public static InstrumentCabinet getInstrCabinet() {
        return _instrCabinet;
    }

    public static float getBpm() {
        return _bpm;
    }

    public static void setBpm(float bpm) {
        _bpm = bpm;
    }

    public LayerSet getLayerSet() {
        return this._layerSet;
    }

    public ViewingPlatform getViewingPlatform() {
        return this._suniverse.getViewingPlatform();
    }

    public Canvas3DExt getCanvas3D() {
        return this._canvas3D;
    }

    public static Bounds getSceneBounds() {
        return _bounds;
    }

    public JFrame getParentWindow() {
        return this._parentWindow;
    }

    public void addKeyListener(KeyAdapter k) {
        this._canvas3D.addKeyListener(k);
    }

    private void createSceneGraph() {
        this._sceneBG = new BranchGroup();
        _bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.lightScene();
        this.addBackground();
        this._pickableObjBG = new BranchGroup();
        this._pickableObjBG.setCapability(14);
        this._pickableObjBG.setCapability(13);
        this._ground = new GroundShape();
        this._layerSet = new LayerSet();
        this._layersBG = new BranchGroup();
        this._layersBG.setCapability(14);
        this._layersBG.setCapability(13);
        this.createNewLayer(0, false, false);
        this.createControllers();
        this._sceneBG.addChild((Node)this._pickableObjBG);
        this._sceneBG.compile();
    }

    protected void showContents() {
        this._pickableObjBG.addChild((Node)this._layersBG);
        this._pickableObjBG.addChild((Node)this._ground.getBG());
    }

    public Layer createNewLayer(int type, boolean createSCGroup, boolean createLayerAboveCurrent) {
        Layer newLayer = new Layer(this.getLayerSet().getLayerNum(), type);
        newLayer.setHeight(this.getCurrLevelHeight(createLayerAboveCurrent));
        this._layerSet.addLayer(newLayer);
        this._layersBG.addChild((Node)newLayer.getLayerBG());
        DbgTools.print("Created layer#" + newLayer.getId() + " at height" + this.getCurrLevelHeight(createLayerAboveCurrent));
        if (this.isOSCMode() && createSCGroup) {
            try {
                newLayer.setSCGroup(Group.tail(((SceneCoreOSC)this).getSCStdGrp()));
                DbgTools.print("Created group for layer#" + newLayer.getId());
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
        }
        return newLayer;
    }

    private void lightScene() {
        AmbientLight ambientLightNode = new AmbientLight(Colors.ambientLight);
        ambientLightNode.setInfluencingBounds((Bounds)_bounds);
        this._sceneBG.addChild((Node)ambientLightNode);
        Vector3f light1Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        Vector3f light2Direction = new Vector3f(1.0f, -1.0f, 1.0f);
        DirectionalLight light1 = new DirectionalLight(Colors.directionalLight, light1Direction);
        light1.setInfluencingBounds((Bounds)_bounds);
        this._sceneBG.addChild((Node)light1);
    }

    private void addBackground() {
        Background back = new Background();
        back.setApplicationBounds((Bounds)_bounds);
        back.setColor(Colors.background);
        this._sceneBG.addChild((Node)back);
    }

    public GuiCtrl getGuiCtrl() {
        return this._guiCtrl;
    }

    public static String getInstrTextureDir() {
        return "./textures/instruments";
    }

    public float getCurrLevelHeight() {
        return this.getCurrLevelHeight(false);
    }

    public float getCurrLevelHeight(boolean newLayer) {
        return 0.5f * (float)(this._layerSet.getCurrLayerLevel() + (newLayer ? 1 : 0));
    }

    public void toggleCurrLayerType() {
        if (this._layerSet.getCurrLayer().getGraphs().size() > 0) {
            return;
        }
        int newType = this.getCurrLayer().getType() == 0 ? 1 : 0;
        this.getCurrLayer().setType(newType);
        this._pickingCtrl.changeToLayerType(newType, null);
        this._hud.updateLayerInfo();
        this._hud.updateAvailableInstr();
    }

    public void changeLayer(int newLayerLevel, Instrument instr) {
        if (!this._orbitMode) {
            this._layerSet.setEnabled(-1, false);
        }
        this._layerSet.setCurrLayerLevel(newLayerLevel);
        this._pickingCtrl.changeToLayerType(this.getCurrLayer().getType(), instr);
        if (!this._orbitMode) {
            this._layerSet.setEnabled(-1, true);
        }
        this._ground.setAtHeight(this.getCurrLevelHeight());
    }

    private boolean isOrbitEnabled() {
        return this._guiCtrl.getOrbitControl().getEnable();
    }

    private void setOrbitCtrl(boolean status) {
        this._guiCtrl.getOrbitControl().setEnable(status);
    }

    public void changeOrbitMode() {
        boolean enable = !this.isOrbitEnabled();
        Layer[] layers = this._layerSet.getLayers();
        int i = 0;
        while (i < layers.length) {
            this._layerSet.setEnabled(i, enable);
            ++i;
        }
        if (!enable) {
            this._layerSet.setEnabled(-1, true);
            if (this._pickingCtrl.getCurrInstrument().needsKeyboard()) {
                this._ground.showKeyboard();
            }
        } else {
            this._ground.hideKeyboard();
        }
        this._ground.setPickable(!enable);
        this.setOrbitCtrl(enable);
        this._hud.updateOrbitStatus(enable);
        this._orbitMode = enable;
    }

    public boolean isOrbitMode() {
        return this._orbitMode;
    }

    public void disableOrbitCtrl() {
        if (this._orbitMode) {
            this.setOrbitCtrl(false);
        }
    }

    public void enableOrbitCtrl() {
        if (this._orbitMode) {
            this.setOrbitCtrl(true);
        }
    }
}

