/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui;

import de.sciss.jcollider.Group;
import de.sciss.jcollider.JCollider;
import de.sciss.jcollider.NodeWatcher;
import de.sciss.jcollider.Server;
import de.sciss.jcollider.ServerEvent;
import de.sciss.jcollider.ServerListener;
import de.sciss.jcollider.ServerOptions;
import de.sciss.jcollider.UGenInfo;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCReceiver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import javax.swing.JFrame;
import javax.swing.Timer;
import net.mkonrad.synes.data.Config;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.osc.OSCMsgListener;
import net.mkonrad.synes.osc.OSCMsgProcessor;
import net.mkonrad.synes.osc.OSCMsgSender;
import net.mkonrad.synes.util.DbgTools;
import net.mkonrad.synes.util.ErrTools;
import net.mkonrad.synes.util.FileTools;

public class SceneCoreOSC
extends SceneCore
implements OSCMsgProcessor,
ServerListener {
    private OSCReceiver _oscRecv;
    private OSCMsgListener _oscMsgListener;
    private OSCMsgSender _oscLangTransmitter;
    private Server _scServer;
    private NodeWatcher _scNodeWatcher;
    private Group _scStdGrp;
    private Thread _scOutputDisplayThread;
    private Process _scLangProcess;
    private int _oscLangPort;
    private int _oscServerPort;
    private int _oscSendingPort;
    private int _oscListeningPort;
    private String _scProgramDir;
    private boolean _initCompleted = false;
    private boolean _serverInitialized = false;

    public SceneCoreOSC(JFrame parentWindow, Config conf, boolean oscModeOn) {
        super(parentWindow, conf);
        OSC_MODE = oscModeOn;
        this.initContents();
        if (!OSC_MODE) {
            DbgTools.print("Started in NO-SC mode");
        } else {
            this._oscServerPort = Integer.parseInt(conf.getCfgValue("osc_server_port"));
            this._oscLangPort = Integer.parseInt(conf.getCfgValue("osc_lang_port"));
            this._oscSendingPort = Integer.parseInt(conf.getCfgValue("osc_sending_port"));
            this._oscListeningPort = Integer.parseInt(conf.getCfgValue("osc_listening_port"));
            this._scProgramDir = conf.getCfgValue("sc_program_dir");
            if (!JCollider.isWindows) {
                this.copySCClasses();
                this.startSCScript(this.findSCProg("sclang"));
            }
            this.startSCServer(this.findSCProg("scsynth"));
            this.initOSCLevel1();
            this.registerOSCMsgProcessors();
            DbgTools.print("Started in OSC-mode");
        }
    }

    private void copySCClasses() {
        String homeDir = System.getProperty("user.home");
        String extDir = JCollider.isMacOS ? String.valueOf(homeDir) + "/Library/Application Support/SuperCollider/Extensions" : String.valueOf(homeDir) + "/share/SuperCollider/Extensions";
        File extDirObj = new File(extDir);
        if (!extDirObj.exists()) {
            if (!extDirObj.mkdirs()) {
                ErrTools.print("Could not create SC extension directory: " + extDir);
            } else {
                DbgTools.print("Created SC extensions dir: " + extDir);
            }
        }
        Runtime rtime = Runtime.getRuntime();
        String wd = System.getProperty("user.dir");
        String[] cmd = new String[]{"cp", "-r", String.valueOf(wd) + "/SuperCollider/classes", extDir};
        try {
            Process proc = rtime.exec(cmd);
        }
        catch (Exception e) {
            ErrTools.print(e);
        }
    }

    private String findSCProg(String prog) {
        String fs;
        File f = FileTools.findFile(JCollider.isWindows ? String.valueOf(prog) + ".exe" : prog, new String[]{String.valueOf(fs = File.separator) + this._scProgramDir, String.valueOf(fs) + "Applications" + fs + "SuperCollider", String.valueOf(fs) + "Applications" + fs + "SC3", String.valueOf(fs) + "usr" + fs + "local" + fs + "bin", String.valueOf(fs) + "usr" + fs + "bin", "C:\\Program Files\\SC3", "C:\\Program Files (x86)\\SuperCollider"});
        if (f == null) {
            ErrTools.die("Could not find SC program " + prog);
        }
        return f.getAbsolutePath();
    }

    private void startSCScript(String clientProgram) {
        DbgTools.print("Client resides at " + clientProgram);
        Runtime rtime = Runtime.getRuntime();
        try {
            String progDir = new File(clientProgram).getParent();
            String workingDir = System.getProperty("user.dir");
            this._scLangProcess = rtime.exec(String.valueOf(clientProgram) + " -d" + (JCollider.isMacOS ? progDir : System.getProperty("user.dir")) + " -D " + workingDir + "/SuperCollider/run.sc");
            Runnable startup = new Runnable(){

                @Override
                public void run() {
                    BufferedReader childOutput = new BufferedReader(new InputStreamReader(SceneCoreOSC.this._scLangProcess.getInputStream()));
                    try {
                        String outStr;
                        while ((outStr = childOutput.readLine()) != null) {
                            DbgTools.print(outStr, "SC: ");
                            System.out.flush();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this._scOutputDisplayThread = new Thread(startup);
            this._scOutputDisplayThread.start();
        }
        catch (Exception e) {
            ErrTools.die(e);
        }
    }

    public OSCMsgListener getOSCMsgListener() {
        return this._oscMsgListener;
    }

    private void initOSCLevel1() {
        try {
            DatagramChannel udpChannelRecv = DatagramChannel.open();
            udpChannelRecv.socket().bind(new InetSocketAddress("127.0.0.1", this._oscListeningPort));
            this._oscRecv = OSCReceiver.newUsing(udpChannelRecv);
            this._oscMsgListener = new OSCMsgListener(this, true);
            this._oscRecv.addOSCListener(this._oscMsgListener);
            this._oscRecv.startListening();
            DbgTools.print("*Receiving on port " + this._oscListeningPort);
        }
        catch (Exception e) {
            ErrTools.print(e);
        }
    }

    private void initOSCLevel2() {
        try {
            this._oscLangTransmitter = new OSCMsgSender(this._oscLangPort, this._oscSendingPort);
            DbgTools.print("*Sending from port " + (this._oscSendingPort + 1) + " to OSC server application on port " + this._oscServerPort);
            DbgTools.print("*Sending from port " + this._oscSendingPort + " to OSC lang application on port " + this._oscLangPort);
        }
        catch (Exception e) {
            ErrTools.print(e);
        }
    }

    private void startSCServer(String serverProgram) {
        DbgTools.print("Server resides at " + serverProgram);
        try {
            UGenInfo.readBinaryDefinitions();
            this._scServer = new Server("synesServerJava", new InetSocketAddress("localhost", 57110), new ServerOptions(), 2);
            Server.setProgram(serverProgram);
            this._scServer.addListener(this);
            this._scServer.start();
            this._scServer.startAliveThread();
        }
        catch (IOException e) {
            ErrTools.print(e);
        }
    }

    private void initServer() throws IOException {
        if (this._serverInitialized) {
            return;
        }
        this._scServer.initTree();
        this._scNodeWatcher = NodeWatcher.newFrom(this._scServer);
        this._scStdGrp = this._scServer.getDefaultGroup();
        this._scNodeWatcher.register(this._scStdGrp);
        DbgTools.print("Initialized server. Standard group has NodeID " + this._scStdGrp.getNodeID());
        this._serverInitialized = true;
    }

    @Override
    public void serverAction(ServerEvent e) {
        switch (e.getID()) {
            case 0: {
                try {
                    this.initServer();
                }
                catch (IOException e1) {
                    ErrTools.print(e1);
                }
                break;
            }
            case 1: {
                Timer t = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (SceneCoreOSC.this._scServer != null) {
                                SceneCoreOSC.this._scServer.startAliveThread();
                            }
                        }
                        catch (IOException e1) {
                            ErrTools.print(e1);
                        }
                    }
                });
                t.setRepeats(false);
                t.start();
                break;
            }
        }
    }

    private void registerOSCMsgProcessors() {
        this._oscMsgListener.addProcessor(this);
        this._oscMsgListener.addProcessor(this.getPickingCtrl());
    }

    @Override
    public boolean canHandleOSCMsg(String name) {
        return name.equals("/init") || name.equals("/initComplete");
    }

    @Override
    public void processOSCMsg(OSCMessage msg) {
        if (this._initCompleted) {
            return;
        }
        DbgTools.print("Received OSC message: " + msg.getName());
        if (msg.getName().equals("/init")) {
            this._oscServerPort = Integer.parseInt(msg.getArg(0).toString());
            this._oscLangPort = Integer.parseInt(msg.getArg(1).toString());
            this.initOSCLevel2();
        } else if (msg.getName().equals("/initComplete")) {
            try {
                this.initServer();
                this.getCurrLayer().setSCGroup(Group.tail(this.getSCStdGrp()));
                DbgTools.print("Created group " + this.getCurrLayer().getSCGroup().getNodeID());
            }
            catch (IOException e) {
                ErrTools.print(e);
            }
            this._hud.hideLoadingMsg();
            this.showContents();
            this._initCompleted = true;
        }
    }

    public void shutdown() {
        if (!OSC_MODE) {
            return;
        }
        try {
            DbgTools.print("Sending /quit to client...");
            this.getSCLang().sendOSCData("/quit");
            DbgTools.print("Sending /quit to server...");
            this._scServer.quitAndWait();
            if (this._scLangProcess != null) {
                DbgTools.print("Terminating sclang...");
                this._scLangProcess.destroy();
                this._scOutputDisplayThread.join(500L);
            }
        }
        catch (Exception e) {
            ErrTools.print(e);
        }
    }

    public Server getSCServer() {
        return this._scServer;
    }

    public OSCMsgSender getSCLang() {
        return this._oscLangTransmitter;
    }

    public Group getSCStdGrp() {
        return this._scStdGrp;
    }
}

