/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.data.AbstractGraph;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.instruments.InstrumentShape;
import net.mkonrad.synes.gui.style.Colors;
import net.mkonrad.synes.util.Common3DTools;

public abstract class AbstractGraphLine
extends Shape3D {
    protected SceneCore _sceneCtrl;
    protected AbstractGraph _graph;
    protected BranchGroup _bg;
    protected TransformGroup _tg;
    protected BranchGroup _lineLabelsBG;
    protected ArrayList<TransformGroup> _lineLabelsTGs;
    protected ArrayList<Point3f> _coords;
    protected SynthObj _pointerObj;
    protected Point3f _lastMovePoint;
    protected float _currDistance = 0.0f;
    protected static float lineWidthRatio = 3.0f;

    public AbstractGraphLine(SceneCore sceneCtrl) {
        this._sceneCtrl = sceneCtrl;
        this._coords = new ArrayList();
        this._lineLabelsTGs = new ArrayList();
        this.setPickable(true);
        this.setCapability(6);
        this._bg = new BranchGroup();
        this._bg.setCapability(17);
        this._bg.setCapability(14);
        this._bg.setCapability(13);
        this._tg = new TransformGroup();
        this._tg.setCapability(18);
        this._tg.setCapability(14);
        this._tg.setCapability(13);
        this._bg.addChild((Node)this._tg);
        this._lineLabelsBG = new BranchGroup();
        this._lineLabelsBG.setCapability(17);
        this._lineLabelsBG.setCapability(14);
        this._lineLabelsBG.setCapability(13);
    }

    public BranchGroup getBG() {
        return this._bg;
    }

    public TransformGroup getTG() {
        return this._tg;
    }

    public Vector3f getPos() {
        Vector3f posVec = new Vector3f();
        Transform3D t3d = new Transform3D();
        this._tg.getTransform(t3d);
        t3d.get(posVec);
        return posVec;
    }

    public void setPos(Point3f posVec) {
        this.setPos(new Vector3f(posVec.x, posVec.y, 0.0f));
    }

    public void setPos(Vector3f posVec) {
        posVec.z = 0.0f;
        Transform3D t3d = new Transform3D();
        this._tg.getTransform(t3d);
        t3d.setTranslation(posVec);
        this._tg.setTransform(t3d);
    }

    public AbstractGraph getGraph() {
        return this._graph;
    }

    public SynthObj getPointerObj() {
        return this._pointerObj;
    }

    public void changePointerObj(SynthObj pointerObj) {
        this._pointerObj = pointerObj;
        this.setPointerShape(pointerObj.getInstrumentShape());
    }

    public void changePointerInstrument(Instrument instr) {
        this.hidePointerShape();
        this._pointerObj.setInstrument(instr);
        this.setPointerShape(instr.createInstrumentShape(this._pointerObj, this._lastMovePoint));
        this.updateGeometry();
    }

    private void setPointerShape(InstrumentShape pointerShape) {
        this._pointerObj.setInstrumentShape(pointerShape);
        pointerShape.getPrimitive().setPickable(false);
        this._tg.addChild((Node)pointerShape.getBG());
    }

    public void hidePointerShape() {
        if (this._pointerObj != null) {
            this._pointerObj.getInstrumentShape().getBG().detach();
        }
    }

    public void setEnabled(boolean enabled) {
        this.setPickable(enabled);
        if (enabled) {
            this.setTransparency(0.0f);
        } else {
            this.setTransparency(0.75f);
        }
    }

    public void initGraph(AbstractGraph graph) {
        this._graph = graph;
    }

    public void initLine(Point3f pointer, SynthObj pointerObj) {
        this.changePointerObj(pointerObj);
        this.createGeometry();
        pointer.add((Tuple3f)new Vector3f(0.01f, 0.0f, 0.0f));
        this.addLinePoints(this.getSynthObj(0), new Vector3f((Tuple3f)pointer));
        this.addLineLabel();
        this.updateLineLabel(0, this.getSynthObj(0).getPos(), new Vector3f((Tuple3f)pointer), "");
        this._tg.addChild((Node)this._lineLabelsBG);
    }

    public void releaseMove(Point3f pointer) {
        this.setPickable(true);
        this._lineLabelsBG.removeAllChildren();
        this._lineLabelsBG.detach();
        this._lineLabelsTGs.clear();
        this._currDistance = 0.0f;
        this.hidePointerShape();
        this._pointerObj = null;
    }

    public abstract void movedPointer(Point3f var1);

    public abstract void movedObj(SynthObj var1);

    public abstract void clicked(SynthObj var1);

    public void canceled() {
        if (this._graph.size() <= 1) {
            this._graph.clear();
        } else {
            this.cleanUpTail();
        }
    }

    public void updateGeometry() {
        this.setGeometry(this._coords);
    }

    public void setGeometry(ArrayList<Point3f> coords) {
        int numPoints = coords.size();
        QuadArray linesAr = new QuadArray(numPoints, 5);
        Point3f[] points = new Point3f[numPoints];
        coords.toArray(points);
        coords = null;
        linesAr.setCoordinates(0, points);
        Color3f[] lineColors = new Color3f[numPoints];
        int i = 0;
        while (i < numPoints) {
            lineColors[i] = this.calcLineColor(i);
            ++i;
        }
        linesAr.setColors(0, lineColors);
        this.setGeometry((Geometry)linesAr);
    }

    public void cleanUpTail() {
        int size = this._coords.size();
        int i = 1;
        while (i <= 4) {
            this._coords.remove(size - i);
            ++i;
        }
        this.updateGeometry();
        this._pointerObj.getInstrumentShape().getBG().detach();
        this._pointerObj = null;
    }

    protected SynthObj getSynthObj(int index) {
        return (SynthObj)this._graph.get(0);
    }

    protected void addLinePoints(SynthObj synth1, Vector3f pointer) {
        Point3f[] points = this.calcLinePoints(synth1.getPos(), synth1.getAmp() / lineWidthRatio, pointer, 0.1f / lineWidthRatio);
        int i = 0;
        while (i < points.length) {
            this._coords.add(points[i]);
            ++i;
        }
    }

    protected void updateLinePoints(SynthObj synth1, Vector3f pointer) {
        int updateStart = -1;
        if (synth1 == null) {
            updateStart = this._coords.size() - 4;
        }
        this.updateLinePoints(synth1, pointer, 0.1f, updateStart);
    }

    public void updateLinePoints(SynthObj synth1, SynthObj synth2) {
        int updateStart = -1;
        if (synth1 == null) {
            int synthIndex = this._graph.indexOf(synth2);
            if (synthIndex < 0) {
                updateStart = this._coords.size() - 4;
                if (this._sceneCtrl.getCurrLayer().getType() == 1 && synth2 instanceof Modulator) {
                    synth1 = (SynthObj)this._graph.get(0);
                }
            } else {
                updateStart = synthIndex * 4 - 4;
            }
            if (updateStart < 0) {
                synth1 = synth2;
                synth2 = ((SynthGraph)this._graph).getModulator();
                if (synth2 == null) {
                    synth2 = this._pointerObj;
                }
            }
        }
        this.updateLinePoints(synth1, synth2.getPos(), synth2.getAmp(), updateStart);
    }

    protected void updateLinePoints(SynthObj synth1, Vector3f synth2Pos, float synth2Amp, int updateStart) {
        float synth1Amp;
        Vector3f synth1Pos;
        if (synth1 == null) {
            synth1Pos = ((SynthGraph)this._graph).getModulator().getPos();
            synth1Amp = ((SynthGraph)this._graph).getModulator().getAmp();
        } else {
            synth1Pos = synth1.getPos();
            synth1Amp = synth1.getAmp();
        }
        Point3f[] points = this.calcLinePoints(synth1Pos, synth1Amp / lineWidthRatio, synth2Pos, synth2Amp / lineWidthRatio);
        if (updateStart < 0) {
            updateStart = this._graph.indexOf(synth1) * 4;
        }
        int i = 0;
        while (i < points.length) {
            this._coords.set(updateStart + i, points[i]);
            ++i;
        }
    }

    protected void updateLinePointsBackWay(SynthObj synth1, Vector3f synth2Pos, float synth2Amp) {
        Point3f[] points = this.calcLinePoints(synth1.getPos(), synth1.getAmp() / lineWidthRatio, synth2Pos, synth2Amp / lineWidthRatio);
        int updateStart = this._graph.indexOf(synth1) * 4;
        int i = 0;
        while (i < points.length) {
            this._coords.set(updateStart + i, points[i]);
            ++i;
        }
    }

    protected Point3f[] calcLinePoints(Vector3f p1, float scale1, Vector3f p2, float scale2) {
        Vector2f normal = new Vector2f(-(p2.y - p1.y), p2.x - p1.x);
        normal.normalize();
        Vector2f normal2 = (Vector2f)normal.clone();
        normal.scale(scale1);
        normal2.scale(scale2);
        Point3f[] points = new Point3f[4];
        normal.negate();
        points[0] = this.getCornerPoint(p1, normal);
        normal.negate();
        points[1] = this.getCornerPoint(p1, normal);
        points[2] = this.getCornerPoint(p2, normal2);
        normal2.negate();
        points[3] = this.getCornerPoint(p2, normal2);
        return points;
    }

    protected Point3f getCornerPoint(Vector3f p, Vector2f normal) {
        Vector3f cornerP = new Vector3f();
        cornerP.add((Tuple3f)p, (Tuple3f)new Vector3f(normal.x, normal.y, 0.05f));
        return new Point3f(cornerP.x, cornerP.y, 0.005f);
    }

    protected abstract Color3f calcLineColor(int var1);

    protected float calcAngleBetweenSegments(Vector2f v1, Vector2f v2, Vector2f v3) {
        if (v1 == null) {
            return v3.angle(v2);
        }
        Vector2f vTmp = new Vector2f();
        vTmp.sub((Tuple2f)v2, (Tuple2f)v1);
        v3.sub((Tuple2f)v2);
        float rad = (float)Math.acos((v3.x * vTmp.x + v3.y * vTmp.y) / (v3.length() * vTmp.length()));
        return rad -= 1.5707964f;
    }

    protected void addLineLabel() {
        TransformGroup tg = new TransformGroup();
        tg.setCapability(14);
        tg.setCapability(13);
        tg.setCapability(18);
        tg.setPickable(false);
        this._lineLabelsBG.addChild((Node)Common3DTools.wrapInBG((Node)tg, new int[]{17}));
        this._lineLabelsTGs.add(tg);
    }

    protected void updateLineLabel(int index, Vector3f pos1, Vector3f pos2, String labelText) {
        TransformGroup tg = this._lineLabelsTGs.get(index);
        try {
            tg.removeAllChildren();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(this.calcLineLabelPoint(pos1, pos2));
        tg.setTransform(t3d);
        Common3DTools.writeText(tg, labelText, 36, Colors.importantText, "SansSerif", 0);
        this._lineLabelsTGs.set(index, tg);
    }

    private Vector3f calcLineLabelPoint(Vector3f prevPoint, Vector3f thisPoint) {
        Vector3f labelPoint = new Vector3f();
        labelPoint.sub((Tuple3f)thisPoint, (Tuple3f)prevPoint);
        labelPoint.scale(0.5f);
        labelPoint.add((Tuple3f)prevPoint);
        labelPoint.add((Tuple3f)this.getPos());
        labelPoint.z = 0.15f;
        return labelPoint;
    }

    protected float calcDistance(Vector3f pos1, Vector3f pos2) {
        return this.calcDistance(Common3DTools.v2p(pos1), pos2);
    }

    protected float calcDistance(Point3f pointer, Vector3f synthPos) {
        return pointer.distance(Common3DTools.v2p(synthPos));
    }

    private void createGeometry() {
        Appearance app = this.createAppearance();
        this.setAppearance(app);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(6);
        this.setPickable(false);
        this._tg.addChild((Node)this);
    }

    private Appearance createAppearance() {
        Appearance app = new Appearance();
        app.setCapability(11);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        app.setPolygonAttributes(pa);
        return app;
    }

    private TransparencyAttributes createTransparencyAttrib(float t) {
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(t);
        trans.setTransparencyMode(2);
        trans.setCapability(3);
        return trans;
    }

    public void setTransparency(float transValue) {
        TransparencyAttributes transAttrib = transValue <= 0.0f ? new TransparencyAttributes() : this.createTransparencyAttrib(transValue);
        this.getAppearance().setTransparencyAttributes(transAttrib);
    }
}

