/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.ctrl.BeatTimingBehavior;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.BeatGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;
import net.mkonrad.synes.util.MusicTools;

public class BeatGraphLine
extends AbstractGraphLine {
    private BeatTimingBehavior _beatTiming = null;
    private int _currBeatIndex = 0;
    private int _currBeatStep = 1;

    public BeatGraphLine(SceneCore sceneCtrl) {
        super(sceneCtrl);
    }

    public BeatTimingBehavior getBeatTiming() {
        return this._beatTiming;
    }

    public void setBeatTiming(BeatTimingBehavior beatTiming) {
        this._beatTiming = beatTiming;
    }

    @Override
    public void clicked(SynthObj synthObj) {
        Vector3f looseEnd = new Vector3f((Tuple3f)this._lastMovePoint);
        this.addLinePoints(synthObj, looseEnd);
        this.addLineLabel();
        ((Beat)synthObj).getPrevBeat().setDistance(this._currDistance);
        this.updateGeometry();
    }

    @Override
    public void movedPointer(Point3f pointer) {
        if (this._graph.size() < 1) {
            return;
        }
        if (pointer == null && this._lastMovePoint != null) {
            pointer = this._lastMovePoint;
        }
        SynthObj lastSynth = (SynthObj)this._graph.getLast();
        Vector3f pVec = new Vector3f((Tuple3f)pointer);
        this._currDistance = pointer.distance(new Point3f(lastSynth.getPos().x, lastSynth.getPos().y, lastSynth.getPos().z));
        this.updateLinePoints(lastSynth, pVec);
        this.updateLineLabel(this._lineLabelsTGs.size() - 1, lastSynth.getPos(), pVec, String.format("%1$.2f", Float.valueOf(((Beat)lastSynth).getDur())));
        Vector2f v1 = null;
        Vector2f v2 = null;
        Vector2f v3 = null;
        Vector3f vTmp = null;
        if (this._graph.size() > 1) {
            vTmp = ((SynthObj)this._graph.get(this._graph.size() - 2)).getPos();
            v1 = new Vector2f(vTmp.x, vTmp.y);
        }
        vTmp = lastSynth.getPos();
        v2 = new Vector2f(vTmp.x, vTmp.y);
        v3 = new Vector2f(pVec.x, pVec.y);
        lastSynth.getInstrumentShape().turn(this.calcAngleBetweenSegments(v1, v2, v3));
        this._lastMovePoint = pointer;
        this.updateGeometry();
        if (this._pointerObj.getInstrumentShape().getBG().getParent() == null) {
            this._bg.addChild((Node)this._pointerObj.getInstrumentShape().getBG());
        }
        this._pointerObj.getInstrumentShape().setPos(pointer);
    }

    @Override
    public void movedObj(SynthObj synthObj) {
        Beat prevBeat = ((Beat)synthObj).getPrevBeat();
        Beat nextBeat = ((Beat)synthObj).getNextBeat();
        if (this._graph.getState() == 1) {
            if (this._graph.indexOf(synthObj) == 0) {
                prevBeat = (Beat)this._graph.getLast();
            }
            if (this._graph.indexOf(synthObj) == this._graph.size() - 1) {
                nextBeat = (Beat)this._graph.get(0);
            }
        }
        if (prevBeat != null) {
            this.updateLinePoints((SynthObj)prevBeat, synthObj);
        }
        if (nextBeat != null) {
            this.updateLinePoints(synthObj, nextBeat);
        }
        this.updateGeometry();
    }

    public long beat() {
        long timeDelay = 0L;
        Beat beat = ((BeatGraph)this._graph).getBeat(this._currBeatIndex);
        timeDelay = this._graph.getState() == 0 && this._currBeatStep < 0 && this._currBeatIndex > 0 ? MusicTools.beats2ms(((BeatGraph)this._graph).getBeat(this._currBeatIndex - 1).getDur()) : MusicTools.beats2ms(beat.getDur());
        beat.getInstrumentShape().beat();
        if (this._currBeatIndex >= this._graph.size() - 1) {
            if (this._graph.getState() == 0) {
                this._currBeatStep = -1;
            } else {
                this._currBeatStep = 1;
                this._currBeatIndex = -1;
            }
        }
        this._currBeatIndex += this._currBeatStep;
        if (this._currBeatIndex < 0 && this._graph.getState() == 0) {
            this._currBeatIndex = 1;
            this._currBeatStep = 1;
        }
        return timeDelay;
    }

    public void closeBeatGraph() {
        this._graph.setState(1);
        this.updateLinePoints((SynthObj)this._graph.get(this._graph.size() - 1), (SynthObj)this._graph.get(0));
        this.updateGeometry();
    }

    @Override
    protected Color3f calcLineColor(int index) {
        int objIndex = Math.round((float)index * 0.25f);
        if (this._graph.getState() == 0) {
            if (objIndex < this._graph.size()) {
                return ((SynthObj)this._graph.get(objIndex)).getInstrument().getColor();
            }
            return this._pointerObj.getInstrument().getColor();
        }
        return ((SynthObj)this._graph.get(objIndex % this._graph.size())).getInstrument().getColor();
    }
}

