/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import com.sun.j3d.utils.picking.PickTool;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.gui.elements.Keyboard;
import net.mkonrad.synes.gui.style.Colors;

public class GroundShape
extends Shape3D {
    public static final float GROUND_SIZE_X = 10.0f;
    public static final float GROUND_SIZE_Y = 6.0f;
    private BranchGroup _bg = new BranchGroup();
    private TransformGroup _tg;
    private Keyboard _keyboard;
    private boolean _isHidden = true;

    public GroundShape() {
        this._bg.setCapability(14);
        this._bg.setCapability(13);
        this._bg.setCapability(1);
        this._tg = new TransformGroup();
        this._tg.setCapability(18);
        this._tg.setCapability(14);
        this._tg.setCapability(13);
        this._tg.setCapability(1);
        this.setCapability(6);
        this.setCapability(1);
        this.setPickable(true);
        PickTool.setCapabilities((Node)this, (int)4100);
        this.createGeometry();
        this.createAppearance();
        this._keyboard = new Keyboard();
        this._tg.addChild((Node)this);
        this._bg.addChild((Node)this._tg);
    }

    public BranchGroup getBG() {
        return this._bg;
    }

    public void showKeyboard() {
        if (this._isHidden) {
            this._tg.addChild((Node)this._keyboard.getBG());
            this._isHidden = false;
        }
    }

    public void hideKeyboard() {
        if (!this._isHidden) {
            this._tg.removeChild((Node)this._keyboard.getBG());
            this._isHidden = true;
        }
    }

    public void setAtHeight(float h) {
        this.setPos(new Vector3f(0.0f, 0.0f, h));
    }

    public void setPos(Vector3f posVec) {
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(posVec);
        this._tg.setTransform(t3d);
    }

    private void createGeometry() {
        float sX = 5.0f;
        float sY = 3.0f;
        int numLinePoints = 5;
        Shape3D lines = new Shape3D();
        lines.setPickable(false);
        LineStripArray linesGeom = new LineStripArray(numLinePoints, 5, new int[]{numLinePoints});
        Point3f[] linePoints = new Point3f[]{new Point3f(-sX, -sY, 0.0f), new Point3f(-sX, sY, 0.0f), new Point3f(sX, sY, 0.0f), new Point3f(sX, -sY, 0.0f), new Point3f(-sX, -sY, 0.0f)};
        linesGeom.setCoordinates(0, linePoints);
        Color3f[] lineColors = new Color3f[numLinePoints];
        int i = 0;
        while (i < lineColors.length) {
            lineColors[i] = Colors.groundBorders;
            ++i;
        }
        linesGeom.setColors(0, lineColors);
        linesGeom.setCapability(0);
        linesGeom.setCapability(8);
        lines.setGeometry((Geometry)linesGeom);
        this._tg.addChild((Node)lines);
        QuadArray plane = new QuadArray(4, 3);
        Point3f[] cornerPoints = new Point3f[]{new Point3f(-sX, -sY, 0.0f), new Point3f(-sX, sY, 0.0f), new Point3f(sX, sY, 0.0f), new Point3f(sX, -sY, 0.0f)};
        plane.setCoordinates(0, cornerPoints);
        plane.setCapability(0);
        plane.setCapability(8);
        plane.setCapability(17);
        plane.setCapability(22);
        this.setGeometry((Geometry)plane);
    }

    private void createAppearance() {
        Appearance app = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        app.setPolygonAttributes(pa);
        Material mat = new Material();
        mat.setAmbientColor(Colors.ground);
        app.setMaterial(mat);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparencyMode(2);
        trans.setTransparency(1.0f);
        app.setTransparencyAttributes(trans);
        this.setAppearance(app);
    }
}

