/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import com.xith.java3d.overlay.LabelOverlay;
import de.sciss.jcollider.JCollider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import net.mkonrad.synes.data.Instrument;
import net.mkonrad.synes.gui.Canvas3DExt;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.LabelOverlayExt;
import net.mkonrad.synes.gui.style.Colors;
import net.mkonrad.synes.util.Common3DTools;
import net.mkonrad.synes.util.ErrTools;

public class HUDOverlay {
    private SceneCore _sceneCore;
    private Canvas3DExt _canvas3D;
    private TransformGroup _viewTG;
    private BranchGroup _instrChoiceBG;
    private Color _defaultColor;
    private Font _defaultFont;
    private ArrayList<LabelOverlayExt> _instrLbls;
    private LabelOverlay _orbitOnOffLbl;
    private LabelOverlay _layerInfoLbl;
    private LabelOverlay _levelLbl;
    private BranchGroup _loadingLblBG;
    private int _selectedInstrIndex;

    public HUDOverlay(SceneCore sceneCore) {
        this._sceneCore = sceneCore;
        this._canvas3D = this._sceneCore.getCanvas3D();
        this._viewTG = this._sceneCore.getViewingPlatform().getViewPlatformTransform();
        this._selectedInstrIndex = 0;
        this._instrLbls = new ArrayList();
        this._defaultColor = new Color(Colors.text.x, Colors.text.y, Colors.text.z);
        this._defaultFont = new Font("Arial", 1, 14);
    }

    public void display() {
        this._viewTG.addChild((Node)this.createTitle());
        this._viewTG.addChild((Node)this.createLayerInfo());
        this._instrChoiceBG = new BranchGroup();
        this._instrChoiceBG.setCapability(14);
        this._instrChoiceBG.setCapability(13);
        this._instrChoiceBG.addChild((Node)this.createInstrChoice());
        this._viewTG.addChild((Node)this._instrChoiceBG);
        this._viewTG.addChild(this.createOrbitDisplay());
        this._viewTG.addChild((Node)this.createLevelDisplay());
    }

    public void displayLoadingMsg() {
        this._viewTG.addChild((Node)this.createLoadingMsg());
    }

    public void hideLoadingMsg() {
        this._viewTG.removeChild((Node)this._loadingLblBG);
    }

    public void updateAvailableInstr() {
        this._instrChoiceBG.removeAllChildren();
        this._instrChoiceBG.addChild((Node)this.createInstrChoice());
    }

    public void updateInstrChoice(int index) {
        try {
            if (this._selectedInstrIndex < this._instrLbls.size()) {
                this._instrLbls.get(this._selectedInstrIndex).setSelected(false);
            }
            this._instrLbls.get(index).setSelected(true);
            this._selectedInstrIndex = index;
        }
        catch (IndexOutOfBoundsException e) {
            ErrTools.print("Could not update HUD: Label from Instrument #" + index + " not found!");
        }
    }

    public void updateOrbitStatus(boolean on) {
        this._orbitOnOffLbl.setText(on ? "On" : "Off");
    }

    public void updateLayerInfo() {
        this._layerInfoLbl.setText(this.getLayerInfoText());
        this._levelLbl.setText(this.getLevelInfoText());
    }

    private String getLayerInfoText() {
        return this._sceneCore.getCurrLayer().getType() == 0 ? "SEQ-Layer" : "SYNTH-Layer";
    }

    private BranchGroup createLayerInfo() {
        this._layerInfoLbl = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(700, 10, 100, 20), this.getLayerInfoText(), this._defaultFont, this._defaultColor);
        return this._layerInfoLbl.getRoot();
    }

    private BranchGroup createLoadingMsg() {
        int w;
        int x;
        String msg;
        if (!JCollider.isWindows) {
            msg = "Booting SC server / connecting...";
            x = 250;
            w = 400;
        } else {
            msg = "You are running Windows! Better run the start-script now: synesthesia\\SuperCollider\\run-win.sc";
            x = 50;
            w = 700;
        }
        LabelOverlay loadingMsg = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(x, 280, w, 20), msg, this._defaultFont, this._defaultColor);
        this._loadingLblBG = Common3DTools.wrapInBG((Node)loadingMsg.getRoot(), new int[]{17});
        return this._loadingLblBG;
    }

    private BranchGroup createInstrChoice() {
        int lblW = 100;
        int lblH = 20;
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.setCapability(14);
        this._instrLbls.clear();
        this._canvas3D.clearInstrImgs();
        ArrayList<Instrument> cab = SceneCore.getInstrCabinet().get(this._sceneCore.getCurrLayer().getType());
        Color textColor = new Color(Colors.text.x, Colors.text.y, Colors.text.z);
        int i = 0;
        while (i < cab.size()) {
            int x = 30 + i * lblW;
            int y = 35;
            Instrument instr = cab.get(i);
            String instrName = instr.getName();
            instrName = instrName.replaceFirst("synes_", "");
            LabelOverlayExt label = new LabelOverlayExt((Canvas3D)this._canvas3D, new Rectangle(x, y, lblW, lblH), String.valueOf(instr.getKey()) + ": " + instrName, this._defaultFont, textColor, this._selectedInstrIndex == i);
            this._canvas3D.addInstrImg(x - 20, y + 2, "icon." + instr.getIcon());
            this._instrLbls.add(label);
            bg.addChild((Node)label.getRoot());
            ++i;
        }
        return bg;
    }

    private BranchGroup createTitle() {
        LabelOverlay label = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(10, 10, 200, 20), "SYNCUBE", this._defaultFont, this._defaultColor);
        return label.getRoot();
    }

    private Node createOrbitDisplay() {
        boolean status = this._sceneCore.getGuiCtrl().getOrbitControl().getEnable();
        LabelOverlay labelTitle = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(10, 570, 200, 20), "Orbit", this._defaultFont, this._defaultColor);
        this._orbitOnOffLbl = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(50, 570, 200, 20), status ? "On" : "Off", this._defaultFont, this._defaultColor);
        BranchGroup onOffBG = this._orbitOnOffLbl.getRoot();
        onOffBG.setCapability(17);
        this._viewTG.addChild((Node)onOffBG);
        return labelTitle.getRoot();
    }

    private BranchGroup createLevelDisplay() {
        LabelOverlay label = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(700, 570, 200, 20), "Level", this._defaultFont, this._defaultColor);
        this._levelLbl = new LabelOverlay((Canvas3D)this._canvas3D, new Rectangle(750, 570, 200, 20), this.getLevelInfoText(), this._defaultFont, this._defaultColor);
        BranchGroup lvlBG = this._levelLbl.getRoot();
        lvlBG.setCapability(17);
        this._viewTG.addChild((Node)lvlBG);
        return label.getRoot();
    }

    private String getLevelInfoText() {
        return new String("" + (this._sceneCore.getCurrLayer().getId() + 1));
    }
}

