/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import net.mkonrad.synes.gui.style.Colors;

public class Keyboard {
    private Color3f _colorWhite = Colors.white;
    private Color3f _colorBlack = Colors.black;
    private BranchGroup _bg = new BranchGroup();
    private Appearance _app;

    public Keyboard() {
        this._bg.setCapability(17);
        this._bg.setPickable(false);
        this.createAppearance();
        this.createGeometry();
    }

    public BranchGroup getBG() {
        return this._bg;
    }

    public float getKeyWidth() {
        return 0.1f;
    }

    private void createGeometry() {
        int whitePointsSize = 140;
        int blackPointsSize = 100;
        Point3f[] whitePoints = new Point3f[whitePointsSize];
        Point3f[] blackPoints = new Point3f[blackPointsSize];
        Color3f[] whiteColors = new Color3f[whitePointsSize];
        Color3f[] blackColors = new Color3f[blackPointsSize];
        QuadArray whitePlanes = new QuadArray(whitePointsSize, 5);
        whitePlanes.setCapability(1);
        QuadArray blackPlanes = new QuadArray(blackPointsSize, 5);
        blackPlanes.setCapability(1);
        Shape3D whiteKeys = new Shape3D();
        Shape3D blackKeys = new Shape3D();
        whiteKeys.setPickable(false);
        blackKeys.setPickable(false);
        int wPntCounter = 0;
        int bPntCounter = 0;
        float x = 5.0f;
        float y = -3.0f;
        float keyWidth = this.getKeyWidth();
        int oct = 0;
        while (oct < 5) {
            boolean isWhite = true;
            int key = 0;
            while (key < 12) {
                isWhite = key != 0 && key != 5 ? !isWhite : true;
                if (isWhite) {
                    wPntCounter = this.createPoints(wPntCounter, whitePoints, whiteColors, this._colorWhite, x, y, 0.0f, keyWidth);
                } else {
                    bPntCounter = this.createPoints(bPntCounter, blackPoints, blackColors, this._colorBlack, x, y, 0.0f, keyWidth);
                }
                y += keyWidth;
                ++key;
            }
            ++oct;
        }
        whitePlanes.setCoordinates(0, whitePoints);
        blackPlanes.setCoordinates(0, blackPoints);
        whitePlanes.setColors(0, whiteColors);
        blackPlanes.setColors(0, blackColors);
        whiteKeys.setGeometry((Geometry)whitePlanes);
        blackKeys.setGeometry((Geometry)blackPlanes);
        whiteKeys.setAppearance(this._app);
        blackKeys.setAppearance(this._app);
        this._bg.addChild((Node)whiteKeys);
        this._bg.addChild((Node)blackKeys);
    }

    private int createPoints(int counter, Point3f[] array, Color3f[] colors, Color3f setColor, float x, float y, float z, float keyWidth) {
        array[counter * 4] = new Point3f(-x, y, z);
        array[counter * 4 + 1] = new Point3f(x, y, z);
        array[counter * 4 + 2] = new Point3f(x, y + keyWidth, z);
        array[counter * 4 + 3] = new Point3f(-x, y + keyWidth, z);
        int i = counter * 4;
        while (i < counter * 4 + 4) {
            colors[i] = setColor;
            ++i;
        }
        return counter + 1;
    }

    private void createAppearance() {
        this._app = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        this._app.setPolygonAttributes(pa);
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(0.75f);
        trans.setTransparencyMode(2);
        trans.setCapability(3);
        this._app.setTransparencyAttributes(trans);
    }
}

