/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import com.xith.java3d.overlay.LabelOverlay;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.media.j3d.Canvas3D;
import javax.vecmath.Color3f;
import net.mkonrad.synes.gui.style.Colors;

public class LabelOverlayExt
extends LabelOverlay {
    private static final Color3f SELECTED_COLOR = Colors.textBorders;
    private boolean _selected;

    public LabelOverlayExt(Canvas3D canvas, Rectangle space, String text, Font font, Color color, boolean selected) {
        super(canvas, space, text, font, color, null);
        this._selected = selected;
    }

    public void setSelected(boolean s) {
        this._selected = s;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g) {
        if (this.text != null) {
            AttributedString attributedString = this.text;
            synchronized (attributedString) {
                AttributedCharacterIterator characterIterator = this.text.getIterator(null, 0, this.visibleLength);
                if (characterIterator.getEndIndex() > 0) {
                    TextLayout textLayout = new TextLayout(characterIterator, g.getFontRenderContext());
                    if (this._selected) {
                        Rectangle2D.Float outline = new Rectangle2D.Float(0.0f, this.getBounds().height - 2, (float)textLayout.getBounds().getWidth() + 10.0f, 1.0f);
                        g.setColor(new Color(LabelOverlayExt.SELECTED_COLOR.x, LabelOverlayExt.SELECTED_COLOR.y, LabelOverlayExt.SELECTED_COLOR.z));
                        g.draw(outline);
                    }
                    textLayout.draw(g, 4.0f, 3 * this.getBounds().height / 4);
                }
            }
        }
    }
}

