/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements;

import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.data.Modulator;
import net.mkonrad.synes.data.SynthGraph;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.AbstractGraphLine;

public class SynthGraphLine
extends AbstractGraphLine {
    public SynthGraphLine(SceneCore sceneCtrl) {
        super(sceneCtrl);
    }

    @Override
    public void clicked(SynthObj synthObj) {
        Vector3f looseEnd = new Vector3f((Tuple3f)this._lastMovePoint);
        looseEnd.add((Tuple3f)new Point3f(0.01f, 0.0f, 0.0f));
        Modulator addedMod = null;
        Modulator oldMod = null;
        try {
            addedMod = (Modulator)synthObj;
        }
        catch (ClassCastException e) {
            oldMod = ((SynthGraph)this._graph).getModulator();
        }
        if (addedMod == null) {
            this.addLinePoints(oldMod, looseEnd);
        } else {
            this.addLinePoints(addedMod, looseEnd);
        }
        this.addLineLabel();
        if (addedMod != null) {
            ((SynthObj)this._graph.get(0)).setDistance(this._currDistance);
        } else {
            synthObj.setDistance(this._currDistance);
        }
        this.updateGeometry();
    }

    @Override
    public void movedPointer(Point3f pointer) {
        if (this._graph.size() < 1) {
            return;
        }
        if (pointer == null && this._lastMovePoint != null) {
            pointer = this._lastMovePoint;
        }
        SynthObj connectionSynth = ((SynthGraph)this._graph).getModulator();
        boolean modInHand = false;
        if (connectionSynth == null) {
            connectionSynth = (SynthObj)this._graph.get(0);
            modInHand = true;
        }
        Vector3f pVec = new Vector3f((Tuple3f)pointer);
        this._currDistance = this.calcDistance(pointer, connectionSynth.getPos());
        if (modInHand) {
            connectionSynth.setDistance(this._currDistance);
        } else {
            this._pointerObj.setDistance(this._currDistance);
        }
        this.updateLinePoints(this._graph.size() < 2 ? connectionSynth : null, this._pointerObj);
        this.updateLineLabel(this._lineLabelsTGs.size() - 1, connectionSynth.getPos(), pVec, String.format("%1$.2f", Float.valueOf(this._currDistance)));
        this._lastMovePoint = pointer;
        this.updateGeometry();
        if (this._pointerObj.getInstrumentShape().getBG().getParent() == null) {
            this._bg.addChild((Node)this._pointerObj.getInstrumentShape().getBG());
        }
        this._pointerObj.getInstrumentShape().setPos(pointer);
    }

    @Override
    public void movedObj(SynthObj synthObj) {
        Modulator movedMod = null;
        Modulator fixedMod = null;
        try {
            movedMod = (Modulator)synthObj;
        }
        catch (ClassCastException e) {
            fixedMod = ((SynthGraph)this._graph).getModulator();
        }
        float distance = 0.0f;
        if (movedMod == null) {
            this.updateLinePoints(null, synthObj);
            synthObj.setDistance(this.updateDistance(0, fixedMod.getPos(), synthObj.getPos()));
        } else {
            int lblIndex = 0;
            int i = 0;
            while (i < this._graph.size()) {
                SynthObj lineObj = ((SynthGraph)this._graph).getSynthObj(i);
                if (lineObj != movedMod) {
                    lineObj.setDistance(this.updateDistance(lblIndex, movedMod.getPos(), lineObj.getPos()));
                    this.updateLinePoints(null, lineObj);
                    ++lblIndex;
                }
                ++i;
            }
        }
        if (this._lineLabelsBG.getParent() == null) {
            this._bg.addChild((Node)this._lineLabelsBG);
        }
        this.updateGeometry();
    }

    private float updateDistance(int i, Vector3f pos1, Vector3f pos2) {
        float distance = this.calcDistance(pos1, pos2);
        if (this._lineLabelsTGs.size() - 1 < i) {
            this.addLineLabel();
        }
        this.updateLineLabel(i, pos1, pos2, String.format("%1$.2f", Float.valueOf(distance)));
        return distance;
    }

    @Override
    protected Color3f calcLineColor(int index) {
        if (index > 3 && (index % 4 == 0 || index % 4 == 1)) {
            return ((SynthGraph)this._graph).getModulator().getInstrument().getColor();
        }
        int objIndex = Math.round((float)index * 0.25f);
        if (objIndex < this._graph.size()) {
            return ((SynthObj)this._graph.get(objIndex)).getInstrument().getColor();
        }
        return this._pointerObj.getInstrument().getColor();
    }
}

