/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.gui.elements.instruments;

import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.mkonrad.synes.ctrl.anim.BeatAnimBehavior;
import net.mkonrad.synes.data.Beat;
import net.mkonrad.synes.data.SynthObj;
import net.mkonrad.synes.gui.SceneCore;
import net.mkonrad.synes.gui.elements.instruments.InstrumentShape;
import net.mkonrad.synes.util.Common3DTools;
import net.mkonrad.synes.util.MusicTools;
import net.mkonrad.synes.util.TextureTable;

public abstract class AbstractInstrumentShape
implements InstrumentShape {
    private static TextureTable _texTable = null;
    protected BranchGroup _bg;
    protected TransformGroup _tg;
    protected TransformGroup _tgAnim;
    protected TransformGroup _tgRotation;
    protected SynthObj _synthData;
    protected Primitive _primitive;
    protected Appearance _app;
    protected Material _mat;
    protected BranchGroup _beatAnimBG = null;
    protected BeatAnimBehavior _beatAnim = null;
    protected int _beatAnimCycle = 0;
    protected Transform3D _beatAnimTransform;
    protected static int _defaultPrimitiveFlags = 3;

    public AbstractInstrumentShape(SynthObj synthData) {
        if (_texTable == null) {
            _texTable = new TextureTable();
        }
        this._synthData = synthData;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getPrimitive().setPickable(enabled);
        if (enabled) {
            this.setTransparency(0.0f);
        } else {
            this.setTransparency(0.75f);
        }
    }

    protected void init() {
        this._primitive.setPickable(true);
        this._primitive.setCapability(6);
        this._primitive.setUserData((Object)this._synthData);
        this._bg = new BranchGroup();
        this._bg.setCapability(17);
        this._bg.setCapability(14);
        this._bg.setCapability(13);
        this._bg.setCapability(1);
        this._bg.setCapability(6);
        this._bg.setPickable(true);
        this._tg = this.makeTG();
        this._tgAnim = this.makeTG();
        this._tgRotation = this.makeTG();
    }

    protected void connectSceneGraphElements() {
        this._tgAnim.addChild((Node)this._primitive);
        this._tgRotation.addChild((Node)this._tgAnim);
        this._tg.addChild((Node)this._tgRotation);
        this._bg.addChild((Node)this._tg);
    }

    private TransformGroup makeTG() {
        TransformGroup tg = new TransformGroup();
        tg.setCapability(18);
        tg.setCapability(17);
        tg.setCapability(1);
        tg.setCapability(6);
        return tg;
    }

    @Override
    public Primitive getPrimitive() {
        return this._primitive;
    }

    protected void initTransform3D(Vector3f coord) {
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3f(coord.x, coord.y, 0.0f));
        t3d.setRotation(new AxisAngle4f(1.0f, 0.0f, 0.0f, 1.5707964f));
        this._tg.setTransform(t3d);
        this.rescale();
    }

    protected void createAppearance() {
        this._app = new Appearance();
        this._app.setCapability(11);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        texAttr.setPerspectiveCorrectionMode(1);
        this._app.setTextureAttributes(texAttr);
        this._app.setTexture((Texture)_texTable.getTexture(this._synthData.getInstrument().getTexture()));
        this._mat = new Material();
        this._mat.setAmbientColor(this._synthData.getInstrument().getColor());
        this._app.setMaterial(this._mat);
    }

    private TransparencyAttributes createTransparencyAttrib(float t) {
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setTransparency(t);
        trans.setTransparencyMode(2);
        trans.setCapability(3);
        return trans;
    }

    public void setTransparency(float transValue) {
        TransparencyAttributes transAttrib = transValue <= 0.0f ? new TransparencyAttributes() : this.createTransparencyAttrib(transValue);
        this._app.setTransparencyAttributes(transAttrib);
    }

    protected abstract void createPrimitive();

    @Override
    public void turn(float rad) {
        if (this._synthData.getAmp() <= 0.0f) {
            return;
        }
        Transform3D t3d = new Transform3D();
        this._tgRotation.getTransform(t3d);
        t3d.setIdentity();
        t3d.rotY((double)rad);
        try {
            this._tgRotation.setTransform(t3d);
        }
        catch (BadTransformException badTransformException) {
            // empty catch block
        }
    }

    @Override
    public void rescale() {
        this.rescale(null);
    }

    public void rescale(Transform3D t3d) {
        boolean setAgain = false;
        if (t3d == null) {
            t3d = new Transform3D();
            this._tgAnim.getTransform(t3d);
            setAgain = true;
        }
        t3d.setScale((double)this.getCurrScale());
        if (setAgain) {
            this._tgAnim.setTransform(t3d);
        }
    }

    protected float getCurrScale() {
        return this._synthData.getAmp() / 1.0f + 0.05f;
    }

    @Override
    public BranchGroup getBG() {
        return this._bg;
    }

    @Override
    public SynthObj getSynthData() {
        return this._synthData;
    }

    @Override
    public Vector3f getPos() {
        Vector3f posVec = new Vector3f();
        Transform3D t3d = new Transform3D();
        this._tg.getTransform(t3d);
        t3d.get(posVec);
        return posVec;
    }

    @Override
    public Vector3f getAbsPos() {
        Vector3f pos = this.getPos();
        if (this._synthData.getGraph() != null) {
            pos.add((Tuple3f)this._synthData.getGraph().getGraphLine().getPos());
        }
        return pos;
    }

    @Override
    public TransformGroup getTG() {
        return this._tg;
    }

    @Override
    public void setSynthData(SynthObj synthData) {
        this._synthData = synthData;
    }

    @Override
    public void setPos(Point3f posVec) {
        this.setPos(new Vector3f(posVec.x, posVec.y, 0.0f));
    }

    @Override
    public void setPos(Vector3f posVec) {
        posVec.z = 0.0f;
        Transform3D t3d = new Transform3D();
        this._tg.getTransform(t3d);
        if (this._synthData.getGraph() != null) {
            posVec.sub((Tuple3f)this._synthData.getGraph().getGraphLine().getPos());
        }
        t3d.setTranslation(posVec);
        this._tg.setTransform(t3d);
    }

    @Override
    public void beat() {
        if (this._beatAnim != null) {
            this.resetAnim();
        }
        this._beatAnim = new BeatAnimBehavior(this);
        this._beatAnim.setSchedulingBounds(SceneCore.getSceneBounds());
        this._beatAnimBG = Common3DTools.wrapInBG((Node)this._beatAnim);
        this._beatAnimBG.setCapability(17);
        this._bg.addChild((Node)this._beatAnimBG);
        this._beatAnimCycle = 0;
        this._beatAnimTransform = new Transform3D();
        this._tgAnim.getTransform(this._beatAnimTransform);
    }

    @Override
    public void beatUpdate() {
        if (this._synthData.getAmp() <= 0.0f) {
            return;
        }
        float sustain = MusicTools.beats2ms(((Beat)this._synthData).getSustain());
        float growBorder = sustain / 4.0f;
        float growMaxScale = 0.5f;
        float scaleValue = 1.0f;
        scaleValue = (float)this._beatAnimCycle < growBorder ? this.getCurrScale() * (1.0f + (float)this._beatAnimCycle / growBorder * growMaxScale) : this.getCurrScale() * (1.0f + growMaxScale - (float)this._beatAnimCycle / sustain * growMaxScale);
        this._beatAnimTransform.setScale((double)scaleValue);
        this._tgAnim.setTransform(this._beatAnimTransform);
        this._beatAnimCycle += 25;
        if ((float)this._beatAnimCycle >= sustain) {
            this.resetAnim();
        }
    }

    private void resetAnim() {
        this._beatAnimBG.detach();
        this._beatAnimBG = null;
        this._beatAnim = null;
        this._beatAnimCycle = 0;
        this._beatAnimTransform.setScale((double)this.getCurrScale());
        this._tgAnim.setTransform(this._beatAnimTransform);
    }
}

