/*
 * Decompiled with CFR 0.152.
 */
package net.mkonrad.synes.osc;

import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import java.net.SocketAddress;
import java.util.ArrayList;
import net.mkonrad.synes.gui.SceneCoreOSC;
import net.mkonrad.synes.osc.OSCMsgProcessor;
import net.mkonrad.synes.util.DbgTools;

public class OSCMsgListener
implements OSCListener {
    private boolean _denyNonLocalhost;
    private ArrayList<OSCMsgProcessor> _processors;

    public OSCMsgListener(SceneCoreOSC coreCtrl, boolean denyNonLocalhost) {
        this._denyNonLocalhost = denyNonLocalhost;
        this._processors = new ArrayList();
    }

    public void addProcessor(OSCMsgProcessor proc) {
        this._processors.add(proc);
    }

    public void removeProcessor(OSCMsgProcessor proc) {
        this._processors.remove(proc);
    }

    @Override
    public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
        if (this._denyNonLocalhost && !sender.toString().startsWith("/127.0.0.1")) {
            DbgTools.print("Bad sender! " + sender.toString());
            return;
        }
        boolean handled = false;
        int i = 0;
        while (i < this._processors.size()) {
            if (this._processors.get(i).canHandleOSCMsg(msg.getName())) {
                this._processors.get(i).processOSCMsg(msg);
                handled = true;
            }
            ++i;
        }
        if (!handled) {
            DbgTools.print("No OSCMsgProcessor for msg name: " + msg.getName());
        }
    }
}

